/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.descriptor;

import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstructorDescriptor;
import jakarta.validation.metadata.MethodDescriptor;
import jakarta.validation.metadata.MethodType;
import jakarta.validation.metadata.PropertyDescriptor;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.bval.jsr.descriptor.ConstructorD;
import org.apache.bval.jsr.descriptor.DescriptorManager;
import org.apache.bval.jsr.descriptor.ElementD;
import org.apache.bval.jsr.descriptor.MetadataReader;
import org.apache.bval.jsr.descriptor.MethodD;
import org.apache.bval.jsr.groups.GroupStrategy;
import org.apache.bval.jsr.metadata.Signature;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.util.CollectionSet;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.StringUtils;

public class BeanD<T>
extends ElementD<Class<T>, MetadataReader.ForBean<T>>
implements BeanDescriptor {
    private final Class<T> beanClass;
    private final Map<String, PropertyDescriptor> propertiesMap;
    private final Set<PropertyDescriptor> properties;
    private final Map<Signature, ConstructorD<T>> constructors;
    private final Map<Signature, MethodD> methods;
    private final GroupStrategy groupStrategy;
    private final Set<ConstructorDescriptor> constrainedConstructors;
    private final Map<Set<MethodType>, Set<MethodDescriptor>> methodCache = new HashMap<Set<MethodType>, Set<MethodDescriptor>>();

    BeanD(MetadataReader.ForBean<T> reader) {
        super(reader);
        this.beanClass = (Class)reader.meta.getHost();
        this.groupStrategy = reader.getGroupStrategy();
        this.propertiesMap = reader.getProperties(this);
        this.properties = this.propertiesMap.values().stream().filter(DescriptorManager::isConstrained).collect(ToUnmodifiable.set());
        this.constructors = reader.getConstructors(this);
        this.methods = reader.getMethods(this);
        this.constrainedConstructors = this.constructors.isEmpty() ? Collections.emptySet() : new CollectionSet<ConstructorD<T>>(this.constructors.values());
    }

    @Override
    public Class<?> getElementClass() {
        return this.beanClass;
    }

    @Override
    public boolean isBeanConstrained() {
        return this.hasConstraints() || !this.properties.isEmpty();
    }

    @Override
    public PropertyDescriptor getConstraintsForProperty(String propertyName) {
        return Optional.ofNullable(this.getProperty(propertyName)).filter(this.properties::contains).orElse(null);
    }

    @Override
    public Set<PropertyDescriptor> getConstrainedProperties() {
        return this.properties;
    }

    @Override
    public MethodDescriptor getConstraintsForMethod(String methodName, Class<?> ... parameterTypes) {
        Exceptions.raiseIf(StringUtils.isBlank(methodName), IllegalArgumentException::new, "method name cannot be null/empty/blank", new Object[0]);
        return this.methods.get(new Signature(methodName, parameterTypes));
    }

    @Override
    public Set<MethodDescriptor> getConstrainedMethods(MethodType methodType, MethodType ... methodTypes) {
        return this.methodCache.computeIfAbsent(EnumSet.of(methodType, methodTypes), k -> {
            if (this.methods.isEmpty() || k.isEmpty()) {
                return Collections.emptySet();
            }
            if (k.size() == MethodType.values().length) {
                return new CollectionSet<MethodD>(this.methods.values());
            }
            return this.methods.values().stream().filter(m -> k.contains((Object)m.getMethodType())).collect(ToUnmodifiable.set());
        });
    }

    @Override
    public ConstructorDescriptor getConstraintsForConstructor(Class<?> ... parameterTypes) {
        return this.constructors.get(new Signature(this.beanClass.getName(), parameterTypes));
    }

    @Override
    public Set<ConstructorDescriptor> getConstrainedConstructors() {
        return this.constrainedConstructors;
    }

    public PropertyDescriptor getProperty(String propertyName) {
        Exceptions.raiseIf(StringUtils.isBlank(propertyName), IllegalArgumentException::new, "propertyName was null/empty/blank", new Object[0]);
        return this.propertiesMap.get(propertyName);
    }

    @Override
    protected BeanD<T> getBean() {
        return this;
    }

    @Override
    public GroupStrategy getGroupStrategy() {
        return this.groupStrategy;
    }

    @Override
    public final Type getGenericType() {
        return this.getElementClass();
    }
}

