/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheEntry;
import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.CollectionUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.cache.Cache;

public abstract class AbstractCacheIterator<K, V>
implements Iterator<Cache.Entry<K, V>> {
    protected static final int DEFAULT_FETCH_SIZE = 100;
    protected ICacheInternal<K, V> cache;
    protected List result;
    protected final int partitionCount;
    protected int partitionIndex = -1;
    protected IterationPointer[] pointers;
    protected final int fetchSize;
    protected boolean prefetchValues;
    protected int index;
    protected int currentIndex = -1;

    public AbstractCacheIterator(ICacheInternal<K, V> cache, int partitionCount, int fetchSize, boolean prefetchValues) {
        this.cache = cache;
        this.partitionCount = partitionCount;
        this.fetchSize = fetchSize;
        this.prefetchValues = prefetchValues;
        this.resetPointers();
    }

    @Override
    public boolean hasNext() {
        this.ensureOpen();
        if (this.result != null && this.index < this.result.size()) {
            return true;
        }
        return this.advance();
    }

    @Override
    public Cache.Entry<K, V> next() {
        if (this.hasNext()) {
            this.currentIndex = this.index++;
            Data keyData = this.getKey(this.currentIndex);
            Object key = this.toObject(keyData);
            V value = this.getValue(this.currentIndex, key);
            return new CacheEntry(key, value);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this.ensureOpen();
        if (this.result == null || this.currentIndex < 0) {
            throw new IllegalStateException("Iterator.next() must be called before remove()!");
        }
        Data keyData = this.getKey(this.currentIndex);
        Object key = this.toObject(keyData);
        this.cache.remove(key);
        this.currentIndex = -1;
    }

    protected boolean advance() {
        while (this.partitionIndex < this.getPartitionCount()) {
            if (this.result == null || this.result.size() < this.fetchSize || this.pointers[this.pointers.length - 1].getIndex() < 0) {
                ++this.partitionIndex;
                this.resetPointers();
                this.result = null;
                if (this.partitionIndex == this.getPartitionCount()) {
                    return false;
                }
            }
            this.result = this.fetch();
            if (!CollectionUtil.isNotEmpty(this.result)) continue;
            this.index = 0;
            return true;
        }
        return false;
    }

    private Data getKey(int index) {
        if (this.result != null) {
            if (this.prefetchValues) {
                Map.Entry entry = (Map.Entry)this.result.get(index);
                return (Data)entry.getKey();
            }
            return (Data)this.result.get(index);
        }
        return null;
    }

    private V getValue(int index, K key) {
        if (this.result != null) {
            if (this.prefetchValues) {
                Map.Entry entry = (Map.Entry)this.result.get(index);
                return (V)this.toObject(entry.getValue());
            }
            return (V)this.cache.get(key);
        }
        return null;
    }

    protected void ensureOpen() {
        if (this.cache.isClosed()) {
            throw new IllegalStateException("Cache operations can not be performed. The cache closed");
        }
    }

    protected void resetPointers() {
        this.pointers = new IterationPointer[]{new IterationPointer(Integer.MAX_VALUE, -1)};
    }

    protected void setIterationPointers(List response, IterationPointer[] pointers) {
        if (CollectionUtil.isNotEmpty(response)) {
            this.pointers = pointers;
        }
    }

    protected int getPartitionCount() {
        return this.partitionCount;
    }

    protected abstract List fetch();

    protected abstract Data toData(Object var1);

    protected abstract <T> T toObject(Object var1);
}

