/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.Preconditions;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;

public abstract class AbstractBaseFactoryWithPropertiesConfig<T extends AbstractBaseFactoryWithPropertiesConfig<T>> {
    protected String factoryClassName;
    protected Properties properties = new Properties();

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public T setFactoryClassName(@Nonnull String factoryClassName) {
        this.factoryClassName = Preconditions.checkHasText(factoryClassName, "The factoryClassName cannot be null!");
        return this.self();
    }

    public T setProperty(String name, String value) {
        this.properties.setProperty(name, value);
        return this.self();
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public T setProperties(@Nonnull Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties can't be null");
        }
        this.properties = properties;
        return this.self();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{factoryClassName='" + this.factoryClassName + "', properties=" + this.properties + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBaseFactoryWithPropertiesConfig otherConfig = (AbstractBaseFactoryWithPropertiesConfig)o;
        return Objects.equals(this.properties, otherConfig.properties) && Objects.equals(this.factoryClassName, otherConfig.factoryClassName);
    }

    public int hashCode() {
        return Objects.hash(this.factoryClassName, this.properties);
    }

    protected abstract T self();
}

