/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.app;

import jakarta.inject.Inject;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.openmeetings.IWebSession;
import org.apache.openmeetings.core.ldap.LdapLoginManager;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.dao.room.InvitationDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.server.SOAPLoginDao;
import org.apache.openmeetings.db.dao.server.SessiondataDao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.server.RemoteSessionObject;
import org.apache.openmeetings.db.entity.server.SOAPLogin;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.db.util.FormatHelper;
import org.apache.openmeetings.db.util.LocaleHelper;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.util.OmException;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.OmAuthenticationStrategy;
import org.apache.openmeetings.web.pages.HashPage;
import org.apache.openmeetings.web.user.dashboard.MyRoomsWidget;
import org.apache.openmeetings.web.user.dashboard.MyRoomsWidgetDescriptor;
import org.apache.openmeetings.web.user.dashboard.RssWidget;
import org.apache.openmeetings.web.user.dashboard.RssWidgetDescriptor;
import org.apache.openmeetings.web.user.dashboard.StartWidgetDescriptor;
import org.apache.openmeetings.web.user.dashboard.WelcomeWidgetDescriptor;
import org.apache.openmeetings.web.user.dashboard.admin.AdminWidget;
import org.apache.openmeetings.web.user.dashboard.admin.AdminWidgetDescriptor;
import org.apache.openmeetings.web.user.rooms.RoomEnterBehavior;
import org.apache.openmeetings.web.util.ExtendedClientProperties;
import org.apache.openmeetings.web.util.OmUrlFragment;
import org.apache.openmeetings.web.util.UserDashboard;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.flow.RedirectToUrlException;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.dashboard.Dashboard;
import org.wicketstuff.dashboard.Widget;
import org.wicketstuff.dashboard.WidgetDescriptor;
import org.wicketstuff.dashboard.WidgetFactory;
import org.wicketstuff.dashboard.web.DashboardContext;

public class WebSession
extends AbstractAuthenticatedWebSession
implements IWebSession {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WebSession.class);
    public static final int MILLIS_IN_MINUTE = 60000;
    public static final List<String> AVAILABLE_TIMEZONES = Collections.unmodifiableList(List.of(TimeZone.getAvailableIDs()));
    public static final Set<String> AVAILABLE_TIMEZONE_SET = Collections.unmodifiableSet(new LinkedHashSet<String>(AVAILABLE_TIMEZONES));
    public static final String WICKET_ROOM_ID = "wicketroomid";
    private Long userId = null;
    private Set<User.Right> rights = new HashSet<User.Right>();
    private long languageId = -1L;
    private OmUrlFragment area = null;
    private TimeZone tz;
    private TimeZone browserTz;
    private FastDateFormat iso8601Format = null;
    private FastDateFormat sdf = null;
    private UserDashboard dashboard;
    private Invitation invitation = null;
    private SOAPLogin soap = null;
    private Long roomId = null;
    private Long recordingId = null;
    private boolean kickedByAdmin = false;
    private ExtendedClientProperties extProps = new ExtendedClientProperties();
    @Inject
    private ClientManager cm;
    @Inject
    private InvitationDao inviteDao;
    @Inject
    private SOAPLoginDao soapDao;
    @Inject
    private SessiondataDao sessionDao;
    @Inject
    private GroupDao groupDao;
    @Inject
    private UserDao userDao;
    @Inject
    private LdapLoginManager ldapManager;
    @Inject
    private ConfigurationDao cfgDao;
    @Inject
    private RoomDao roomDao;

    public WebSession(Request request) {
        super(request);
        Injector.get().inject((Object)this);
    }

    public void invalidate() {
        this.cm.invalidate(this.userId, this.getId());
        super.invalidate();
        this.userId = null;
        this.rights = Set.of();
        this.iso8601Format = null;
        this.sdf = null;
        this.languageId = -1L;
        this.invitation = null;
        this.soap = null;
        this.roomId = null;
        this.recordingId = null;
        this.tz = null;
        this.browserTz = null;
        this.extProps = new ExtendedClientProperties();
    }

    public Roles getRoles() {
        if (this.rights.isEmpty()) {
            this.isSignedIn();
        }
        Roles r = new Roles();
        for (User.Right right : this.rights) {
            r.add((Object)right.name());
        }
        return r;
    }

    public boolean isSignedIn() {
        OmAuthenticationStrategy strategy;
        String[] data;
        if (this.userId == null && (data = (strategy = Application.getAuthenticationStrategy()).load()) != null && data.length > 3 && data[2] != null) {
            Long domainId = null;
            try {
                domainId = Long.valueOf(data[3]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!this.signIn(data[0], data[1], User.Type.valueOf((String)data[2]), domainId)) {
                    strategy.remove();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.userId != null && this.userId > 0L;
    }

    private void redirectHash(Room r, Runnable nullAction) {
        if (r != null) {
            String url = this.cm.getServerUrl(r, baseUrl -> {
                PageParameters params = new PageParameters();
                IRequestParameters reqParams = RequestCycle.get().getRequest().getQueryParameters();
                reqParams.getParameterNames().forEach(name -> params.add(name, (Object)reqParams.getParameterValue(name)));
                return Application.urlForPage(HashPage.class, params, baseUrl);
            });
            if (url == null) {
                nullAction.run();
            } else {
                throw new RedirectToUrlException(url);
            }
        }
    }

    public void checkHashes(StringValue secure, StringValue inviteStr) {
        log.debug("checkHashes, secure: '{}', invitation: '{}'", (Object)secure, (Object)inviteStr);
        try {
            log.debug("checkHashes, has soap in session ? '{}'", (Object)(this.soap != null ? 1 : 0));
            if (!(secure.isEmpty() || this.soap != null && this.soap.getHash().equals(secure.toString()))) {
                if (this.isSignedIn()) {
                    log.debug("secure: Session is authorized, going to invalidate");
                    this.invalidateNow();
                }
                this.signIn(secure.toString(), true);
            }
            if (!inviteStr.isEmpty()) {
                if (this.isSignedIn()) {
                    log.debug("invitation: Session is authorized, going to invalidate");
                    this.invalidateNow();
                }
                this.invitation = this.inviteDao.getByHash(inviteStr.toString(), false);
                Room r = null;
                if (this.invitation != null && this.invitation.isAllowEntry()) {
                    HashSet<User.Right> hrights = new HashSet<User.Right>();
                    if (this.invitation.getRoom() != null) {
                        r = this.invitation.getRoom();
                    } else if (this.invitation.getAppointment() != null && this.invitation.getAppointment().getRoom() != null) {
                        r = this.invitation.getAppointment().getRoom();
                    } else if (this.invitation.getRecording() != null) {
                        this.recordingId = this.invitation.getRecording().getId();
                    }
                    if (r != null) {
                        this.redirectHash(r, () -> this.inviteDao.markUsed(this.invitation));
                        hrights.add(User.Right.ROOM);
                        this.roomId = r.getId();
                    }
                    this.setUser(this.invitation.getInvitee(), hrights);
                }
            }
        }
        catch (RedirectToUrlException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected exception while checking hashes", (Throwable)e);
        }
    }

    public void checkToken(StringValue intoken) {
        this.cm.getToken(intoken).ifPresent(token -> {
            this.invalidateNow();
            this.signIn((User)this.userDao.get(token.getUserId()));
            log.debug("Cluster:: Token for room {} is found, signedIn ? {}", (Object)token.getRoomId(), (Object)(this.userId != null ? 1 : 0));
            this.area = RoomEnterBehavior.getRoomUrlFragment(token.getRoomId());
        });
    }

    public boolean signIn(String secureHash, boolean markUsed) {
        SOAPLogin soapLogin = this.soapDao.get(secureHash);
        if (soapLogin == null) {
            log.warn("Secure hash not found in DB");
            return false;
        }
        log.debug("Secure hash found, is used ? {}", (Object)soapLogin.isUsed());
        if (!soapLogin.isUsed() || soapLogin.getAllowSameURLMultipleTimes()) {
            Sessiondata sd = this.sessionDao.check(soapLogin.getSessionHash());
            log.debug("Do we have data for hash ? {}", (Object)(sd.getXml() != null ? 1 : 0));
            if (sd.getXml() != null) {
                RemoteSessionObject remoteUser = RemoteSessionObject.fromString((String)sd.getXml());
                log.debug("Hash data was parsed successfuly; containg exterlaId ? {}", (Object)(!Strings.isEmpty((String)remoteUser.getExternalId()) ? 1 : 0));
                if (!Strings.isEmpty((String)remoteUser.getExternalId())) {
                    Room r = Strings.isEmpty((String)soapLogin.getExternalRoomId()) || Strings.isEmpty((String)soapLogin.getExternalType()) ? this.roomDao.get(soapLogin.getRoomId()) : this.roomDao.getExternal(soapLogin.getExternalType(), soapLogin.getExternalRoomId());
                    if (r == null) {
                        log.warn("Room was not found");
                    } else {
                        this.redirectHash(r, () -> {});
                    }
                    User user = this.userDao.getExternalUser(remoteUser.getExternalId(), remoteUser.getExternalType());
                    if (user == null) {
                        user = UserDao.getNewUserInstance(null);
                        user.setFirstname(remoteUser.getFirstname());
                        user.setLastname(remoteUser.getLastname());
                        user.setLogin(remoteUser.getUsername());
                        user.setType(User.Type.EXTERNAL);
                        user.setExternalId(remoteUser.getExternalId());
                        user.addGroup(this.groupDao.getExternal(remoteUser.getExternalType()));
                        user.getRights().clear();
                        user.getRights().add(User.Right.ROOM);
                        user.getAddress().setEmail(remoteUser.getEmail());
                        user.setPictureUri(remoteUser.getPictureUrl());
                    } else {
                        user.setFirstname(remoteUser.getFirstname());
                        user.setLastname(remoteUser.getLastname());
                        user.setPictureUri(remoteUser.getPictureUrl());
                    }
                    user = this.userDao.update(user, null);
                    if (markUsed) {
                        soapLogin.setUsed(true);
                        soapLogin.setUseDate(new Date());
                        this.soapDao.update(soapLogin);
                    }
                    this.roomId = r == null ? null : r.getId();
                    sd.setUserId(user.getId());
                    sd.setRoomId(this.roomId);
                    this.sessionDao.update(sd);
                    this.setUser(user, null);
                    this.recordingId = soapLogin.getRecordingId();
                    this.soap = soapLogin;
                    log.info("Hash was authorized");
                    return true;
                }
            }
        }
        log.warn("Hash was NOT authorized");
        return false;
    }

    private void setUser(User u, Set<User.Right> rights) {
        this.changeSessionId();
        this.userId = u.getId();
        if (rights == null) {
            HashSet<User.Right> r = new HashSet<User.Right>(u.getRights());
            if (u.getGroupUsers() != null && !AuthLevelUtil.hasAdminLevel(r)) {
                for (GroupUser gu : u.getGroupUsers()) {
                    if (!gu.isModerator()) continue;
                    r.add(User.Right.GROUP_ADMIN);
                    break;
                }
            }
            this.rights = Collections.unmodifiableSet(r);
        } else {
            this.rights = Collections.unmodifiableSet(rights);
        }
        this.languageId = u.getLanguageId();
        this.tz = TimezoneUtil.getTimeZone((User)u);
        this.iso8601Format = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssZ", (TimeZone)this.tz);
        this.setLocale(LocaleHelper.getLocale((User)u));
        this.sdf = FormatHelper.getDateTimeFormat((User)u);
    }

    public boolean signIn(String login, String password, User.Type type, Long domainId) throws OmException {
        User u = switch (type) {
            case User.Type.LDAP -> this.ldapManager.login(login, password, domainId);
            case User.Type.USER -> this.userDao.login(login, password);
            case User.Type.OAUTH -> this.userDao.getByLogin(login, User.Type.OAUTH, domainId);
            default -> throw new OmException("error.unknown");
        };
        if (u == null) {
            return false;
        }
        this.signIn(u);
        return true;
    }

    public boolean signIn(User u) {
        if (u == null) {
            return false;
        }
        this.setUser(u, null);
        return true;
    }

    public static WebSession get() {
        return (WebSession)AbstractAuthenticatedWebSession.get();
    }

    public void setLanguage(long languageId) {
        this.languageId = languageId;
    }

    public static long getLanguage() {
        WebSession.checkIsInvalid();
        WebSession session = WebSession.get();
        if (session.languageId < 0L) {
            session.languageId = session.isSignedIn() ? session.userDao.get(session.userId).getLanguageId() : OpenmeetingsVariables.getDefaultLang().longValue();
        }
        return session.languageId;
    }

    public static Long getUserId() {
        WebSession.checkIsInvalid();
        return WebSession.get().userId;
    }

    public static Long getRecordingId() {
        return WebSession.get().recordingId;
    }

    public Long getRoomId() {
        return WebSession.get().roomId;
    }

    public Invitation getInvitation() {
        return this.invitation;
    }

    public SOAPLogin getSoapLogin() {
        return this.soap;
    }

    public static TimeZone getUserTimeZone() {
        return WebSession.get().tz;
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance(WebSession.get().tz);
    }

    public static Calendar getClientCalendar() {
        return Calendar.getInstance(WebSession.getClientTimeZone());
    }

    public static FastDateFormat getIsoDateFormat() {
        return WebSession.get().iso8601Format;
    }

    public static FastDateFormat getDateFormat() {
        return WebSession.get().sdf;
    }

    public static Set<User.Right> getRights() {
        WebSession.checkIsInvalid();
        return WebSession.get().rights;
    }

    public static void setKickedByAdmin(boolean kicked) {
        WebSession.get().kickedByAdmin = kicked;
    }

    public boolean isKickedByAdmin() {
        return this.kickedByAdmin;
    }

    public OmUrlFragment getArea() {
        return this.area;
    }

    public void setArea(OmUrlFragment area) {
        this.area = area;
    }

    public static Dashboard getDashboard() {
        UserDashboard d = WebSession.get().dashboard;
        if (d == null) {
            WebSession.get().initDashboard();
            d = WebSession.get().dashboard;
        }
        return d;
    }

    public Long getLanguageByLocale() {
        return LabelDao.getLanguage((Locale)this.getLocale(), (Long)OpenmeetingsVariables.getDefaultLang());
    }

    public String getClientTZCode() {
        TimeZone curZone = this.browserTz;
        if (this.browserTz == null) {
            try {
                this.browserTz = this.getClientInfo().getProperties().getTimeZone();
                if (this.browserTz != null && !AVAILABLE_TIMEZONE_SET.contains(this.browserTz.getID())) {
                    for (String availableID : AVAILABLE_TIMEZONES) {
                        TimeZone zone = TimeZone.getTimeZone(availableID);
                        if (!zone.hasSameRules(this.browserTz)) continue;
                        this.browserTz = zone;
                        break;
                    }
                }
                curZone = this.browserTz;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.browserTz == null) {
                curZone = Calendar.getInstance(this.getLocale()).getTimeZone();
            }
        }
        return curZone == null ? null : curZone.getID();
    }

    public static TimeZone getClientTimeZone() {
        String tzCode = WebSession.get().getClientTZCode();
        return tzCode == null ? null : TimeZone.getTimeZone(tzCode);
    }

    private void initDashboard() {
        DashboardContext dashboardContext = Application.getDashboardContext();
        this.dashboard = (UserDashboard)dashboardContext.getDashboardPersister().load();
        boolean existMyRoomWidget = false;
        boolean existRssWidget = false;
        boolean existAdminWidget = false;
        boolean showMyRoomConfValue = OpenmeetingsVariables.isMyRoomsEnabled() && this.cfgDao.getBool("dashboard.show.myrooms", false);
        boolean showRssConfValue = this.cfgDao.getBool("dashboard.show.rssfeed", false);
        boolean showAdminWidget = WebSession.getRights().contains(User.Right.ADMIN);
        boolean save = false;
        WidgetFactory widgetFactory = dashboardContext.getWidgetFactory();
        if (this.dashboard == null) {
            this.dashboard = new UserDashboard("default", "Default");
            this.dashboard.addWidget(widgetFactory.createWidget((WidgetDescriptor)new WelcomeWidgetDescriptor()));
            this.dashboard.addWidget(widgetFactory.createWidget((WidgetDescriptor)new StartWidgetDescriptor()));
            if (showMyRoomConfValue) {
                this.dashboard.addWidget(widgetFactory.createWidget((WidgetDescriptor)new MyRoomsWidgetDescriptor()));
            }
            if (showRssConfValue) {
                this.dashboard.addWidget(widgetFactory.createWidget((WidgetDescriptor)new RssWidgetDescriptor()));
            }
            if (showAdminWidget) {
                this.dashboard.addWidget(widgetFactory.createWidget((WidgetDescriptor)new AdminWidgetDescriptor()));
            }
            save = true;
        } else {
            Iterator iter = this.dashboard.getWidgets().iterator();
            while (iter.hasNext()) {
                Widget w = (Widget)iter.next();
                if (w.getClass().equals(MyRoomsWidget.class)) {
                    existMyRoomWidget = true;
                    if (showMyRoomConfValue) continue;
                    iter.remove();
                    continue;
                }
                if (w.getClass().equals(RssWidget.class)) {
                    existRssWidget = true;
                    if (showRssConfValue) continue;
                    iter.remove();
                    continue;
                }
                if (w.getClass().equals(AdminWidget.class)) {
                    existAdminWidget = true;
                    if (showAdminWidget) continue;
                    iter.remove();
                    continue;
                }
                w.init();
            }
            if (!existMyRoomWidget && showMyRoomConfValue && !this.dashboard.isWidgetMyRoomsDeleted()) {
                this.dashboard.addWidget(widgetFactory.createWidget((WidgetDescriptor)new MyRoomsWidgetDescriptor()));
                save = true;
            }
            if (!existRssWidget && showRssConfValue && !this.dashboard.isWidgetRssDeleted()) {
                this.dashboard.addWidget(widgetFactory.createWidget((WidgetDescriptor)new RssWidgetDescriptor()));
                save = true;
            }
            if (!existAdminWidget && showAdminWidget && !this.dashboard.isWidgetAdminDeleted()) {
                this.dashboard.addWidget(widgetFactory.createWidget((WidgetDescriptor)new AdminWidgetDescriptor()));
                save = true;
            }
        }
        if (save) {
            dashboardContext.getDashboardPersister().save((Dashboard)this.dashboard);
        }
    }

    private static void checkIsInvalid() {
        WebSession session = WebSession.get();
        if (Application.isInvaldSession(session.getId())) {
            WebSession.setKickedByAdmin(true);
            Application.removeInvalidSession(session.getId());
            session.invalidateNow();
            Application.get().restartResponseAtSignInPage();
        }
    }

    public ExtendedClientProperties getExtendedProperties() {
        return this.extProps;
    }
}

