/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.config.security.IdentityConfig;
import com.hazelcast.config.security.StaticCredentialsFactory;
import com.hazelcast.security.ICredentialsFactory;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.util.Objects;

public class UsernamePasswordIdentityConfig
implements IdentityConfig {
    private final String username;
    private final String password;

    public UsernamePasswordIdentityConfig(String name, String password) {
        this.username = name;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public ICredentialsFactory asCredentialsFactory(ClassLoader cl) {
        return new StaticCredentialsFactory(new UsernamePasswordCredentials(this.username, this.password));
    }

    @Override
    public IdentityConfig copy() {
        return new UsernamePasswordIdentityConfig(this.username, this.password);
    }

    public int hashCode() {
        return Objects.hash(this.password, this.username);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsernamePasswordIdentityConfig other = (UsernamePasswordIdentityConfig)obj;
        return Objects.equals(this.password, other.password) && Objects.equals(this.username, other.username);
    }

    public String toString() {
        return "UsernamePasswordIdentityConfig [username=" + this.username + ", password=***]";
    }
}

