/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;

class BuildInfoProvider
implements MetricsProvider {
    static final String PARDOT_ID_ENV_VAR = "HZ_PARDOT_ID";
    private static final int CLASSPATH_MAX_LENGTH = 100000;

    BuildInfoProvider() {
    }

    static String formatClassPath(String classpath) {
        String[] classPathEntries = classpath.split(File.pathSeparator);
        String shortenedEntries = Arrays.stream(classPathEntries).filter(cpEntry -> cpEntry.endsWith(".jar")).map(cpEntry -> cpEntry.substring(cpEntry.lastIndexOf(File.separator) + 1)).collect(Collectors.joining(","));
        return shortenedEntries.substring(0, Math.min(100000, shortenedEntries.length()));
    }

    @Override
    public void provideMetrics(Node node, MetricsCollectionContext context) {
        BuildInfo imdgInfo = node.getBuildInfo();
        context.collect(PhoneHomeMetrics.HAZELCAST_DOWNLOAD_ID, this.getDownloadId());
        context.collect(PhoneHomeMetrics.JAVA_VERSION_OF_SYSTEM, System.getProperty("java.version"));
        context.collect(PhoneHomeMetrics.BUILD_VERSION, imdgInfo.getVersion());
        String classpath = System.getProperty("java.class.path");
        if (classpath != null) {
            context.collect(PhoneHomeMetrics.JAVA_CLASSPATH, BuildInfoProvider.formatClassPath(classpath));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDownloadId() {
        String pardotId = System.getenv(PARDOT_ID_ENV_VAR);
        if (pardotId != null) {
            return pardotId;
        }
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("hazelcast-download.properties");){
            if (is == null) return "source";
            Properties properties = new Properties();
            properties.load(is);
            String string = properties.getProperty("hazelcastDownloadId");
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "source";
    }
}

