/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.basic;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.fortuna.ical4j.validate.ValidationException;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openmeetings.db.entity.HistoricalEntity;
import org.apache.openmeetings.util.mail.IcalHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@NamedQueries(value={@NamedQuery(name="getMailMessageById", query="SELECT m FROM MailMessage m WHERE m.id = :id"), @NamedQuery(name="getMailMessages", query="SELECT m FROM MailMessage m ORDER BY m.updated, m.inserted"), @NamedQuery(name="getMailMessagesByStatus", query="SELECT m FROM MailMessage m WHERE m.status = :status ORDER BY m.updated, m.inserted"), @NamedQuery(name="countMailMessages", query="SELECT COUNT(m) FROM MailMessage m"), @NamedQuery(name="resetMailStatusByDate", query="UPDATE MailMessage m SET m.status = :noneStatus WHERE m.status = :sendingStatus AND m.updated < :date"), @NamedQuery(name="resetMailStatusById", query="UPDATE MailMessage m SET m.errorCount = 0, m.status = :noneStatus WHERE m.id = :id"), @NamedQuery(name="purgeMailMessages", query="DELETE FROM MailMessage m WHERE m.recipients LIKE :email OR m.replyTo LIKE :email")})
@Table(name="email_queue")
public class MailMessage
extends HistoricalEntity
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(MailMessage.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @Lob
    @Column(name="recipients")
    private String recipients;
    @Column(name="replyTo")
    private String replyTo;
    @Column(name="subject")
    private String subject;
    @Lob
    @Column(name="body")
    private String body;
    @Lob
    @Column(name="ics")
    private byte[] ics;
    @Column(name="ics_method")
    private String icsMethod;
    @Column(name="status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private Status status = Status.NONE;
    @Column(name="error_count", nullable=false)
    private int errorCount = 0;
    @Lob
    @Column(name="last_error")
    private String lastError;
    private static int pcInheritedFieldCount = HistoricalEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public MailMessage() {
        this(null, null, null, null, null);
    }

    public MailMessage(String recipients, String replyTo, String subject, String body) {
        this(recipients, replyTo, subject, body, null);
    }

    public MailMessage(String recipients, String replyTo, String subject, String body, IcalHandler ical) {
        this.recipients = recipients;
        this.replyTo = replyTo;
        this.subject = subject;
        this.body = body;
        if (ical != null) {
            this.icsMethod = ical.getMethod().getValue();
            try {
                this.ics = ical.toByteArray();
            }
            catch (IOException | ValidationException e) {
                log.error("Unexpected error while getting ICS", e);
            }
        }
    }

    @Override
    public Long getId() {
        return MailMessage.pcGetid(this);
    }

    @Override
    public void setId(Long id) {
        MailMessage.pcSetid(this, id);
    }

    public String getRecipients() {
        return MailMessage.pcGetrecipients(this);
    }

    public void setRecipients(String recipients) {
        MailMessage.pcSetrecipients(this, recipients);
    }

    public String getReplyTo() {
        return MailMessage.pcGetreplyTo(this);
    }

    public void setReplyTo(String replyTo) {
        MailMessage.pcSetreplyTo(this, replyTo);
    }

    public String getSubject() {
        return MailMessage.pcGetsubject(this);
    }

    public void setSubject(String subject) {
        MailMessage.pcSetsubject(this, subject);
    }

    public String getBody() {
        return MailMessage.pcGetbody(this);
    }

    public void setBody(String body) {
        MailMessage.pcSetbody(this, body);
    }

    public Status getStatus() {
        return MailMessage.pcGetstatus(this);
    }

    public void setStatus(Status status) {
        MailMessage.pcSetstatus(this, status);
    }

    public byte[] getIcs() {
        return MailMessage.pcGetics(this);
    }

    public void setIcs(byte[] ics) {
        MailMessage.pcSetics(this, ics);
    }

    public int getErrorCount() {
        return MailMessage.pcGeterrorCount(this);
    }

    public void setErrorCount(int errorCount) {
        MailMessage.pcSeterrorCount(this, errorCount);
    }

    public String getLastError() {
        return MailMessage.pcGetlastError(this);
    }

    public void setLastError(String lastError) {
        MailMessage.pcSetlastError(this, lastError);
    }

    public String getIcsMethod() {
        return MailMessage.pcGeticsMethod(this) == null ? "REQUEST" : MailMessage.pcGeticsMethod(this);
    }

    static {
        pcPCSuperclass = HistoricalEntity.class;
        pcFieldNames = new String[]{"body", "errorCount", "ics", "icsMethod", "id", "lastError", "recipients", "replyTo", "status", "subject"};
        pcFieldTypes = new Class[]{String.class, Integer.TYPE, byte[].class, String.class, Long.class, String.class, String.class, String.class, Status.class, String.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        PCRegistry.register(MailMessage.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"MailMessage", (PersistenceCapable)new MailMessage());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.body = null;
        this.errorCount = 0;
        this.ics = null;
        this.icsMethod = null;
        this.id = null;
        this.lastError = null;
        this.recipients = null;
        this.replyTo = null;
        this.status = null;
        this.subject = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        MailMessage mailMessage = new MailMessage();
        if (bl) {
            mailMessage.pcClearFields();
        }
        mailMessage.pcStateManager = stateManager;
        mailMessage.pcCopyKeyFieldsFromObjectId(object);
        return mailMessage;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        MailMessage mailMessage = new MailMessage();
        if (bl) {
            mailMessage.pcClearFields();
        }
        mailMessage.pcStateManager = stateManager;
        return mailMessage;
    }

    protected static int pcGetManagedFieldCount() {
        return 10 + HistoricalEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.errorCount = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.ics = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.icsMethod = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.lastError = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.recipients = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.replyTo = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.status = (Status)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 9: {
                this.subject = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.body);
                return;
            }
            case 1: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.errorCount);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.ics);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.icsMethod);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.lastError);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.recipients);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.replyTo);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.status);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.subject);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(MailMessage mailMessage, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(mailMessage, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.body = mailMessage.body;
                return;
            }
            case 1: {
                this.errorCount = mailMessage.errorCount;
                return;
            }
            case 2: {
                this.ics = mailMessage.ics;
                return;
            }
            case 3: {
                this.icsMethod = mailMessage.icsMethod;
                return;
            }
            case 4: {
                this.id = mailMessage.id;
                return;
            }
            case 5: {
                this.lastError = mailMessage.lastError;
                return;
            }
            case 6: {
                this.recipients = mailMessage.recipients;
                return;
            }
            case 7: {
                this.replyTo = mailMessage.replyTo;
                return;
            }
            case 8: {
                this.status = mailMessage.status;
                return;
            }
            case 9: {
                this.subject = mailMessage.subject;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        MailMessage mailMessage = (MailMessage)object;
        if (mailMessage.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(mailMessage, nArray[i]);
        }
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        super.pcCopyKeyFieldsFromObjectId(fieldConsumer, object);
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(4 + pcInheritedFieldCount, (Object)longId.getId());
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(Object object) {
        super.pcCopyKeyFieldsFromObjectId(object);
        LongId longId = (LongId)object;
        this.id = longId.getId();
    }

    @Override
    public Object pcNewObjectIdInstance(Object object) {
        return new LongId(MailMessage.class, (String)object);
    }

    @Override
    public Object pcNewObjectIdInstance() {
        return new LongId(MailMessage.class, this.id);
    }

    private static final String pcGetbody(MailMessage mailMessage) {
        if (mailMessage.pcStateManager == null) {
            return mailMessage.body;
        }
        int n = pcInheritedFieldCount + 0;
        mailMessage.pcStateManager.accessingField(n);
        return mailMessage.body;
    }

    private static final void pcSetbody(MailMessage mailMessage, String string) {
        if (mailMessage.pcStateManager == null) {
            mailMessage.body = string;
            return;
        }
        mailMessage.pcStateManager.settingStringField((PersistenceCapable)mailMessage, pcInheritedFieldCount + 0, mailMessage.body, string, 0);
    }

    private static final int pcGeterrorCount(MailMessage mailMessage) {
        if (mailMessage.pcStateManager == null) {
            return mailMessage.errorCount;
        }
        int n = pcInheritedFieldCount + 1;
        mailMessage.pcStateManager.accessingField(n);
        return mailMessage.errorCount;
    }

    private static final void pcSeterrorCount(MailMessage mailMessage, int n) {
        if (mailMessage.pcStateManager == null) {
            mailMessage.errorCount = n;
            return;
        }
        mailMessage.pcStateManager.settingIntField((PersistenceCapable)mailMessage, pcInheritedFieldCount + 1, mailMessage.errorCount, n, 0);
    }

    private static final byte[] pcGetics(MailMessage mailMessage) {
        if (mailMessage.pcStateManager == null) {
            return mailMessage.ics;
        }
        int n = pcInheritedFieldCount + 2;
        mailMessage.pcStateManager.accessingField(n);
        return mailMessage.ics;
    }

    private static final void pcSetics(MailMessage mailMessage, byte[] byArray) {
        if (mailMessage.pcStateManager == null) {
            mailMessage.ics = byArray;
            return;
        }
        mailMessage.pcStateManager.settingObjectField((PersistenceCapable)mailMessage, pcInheritedFieldCount + 2, (Object)mailMessage.ics, (Object)byArray, 0);
    }

    private static final String pcGeticsMethod(MailMessage mailMessage) {
        if (mailMessage.pcStateManager == null) {
            return mailMessage.icsMethod;
        }
        int n = pcInheritedFieldCount + 3;
        mailMessage.pcStateManager.accessingField(n);
        return mailMessage.icsMethod;
    }

    private static final void pcSeticsMethod(MailMessage mailMessage, String string) {
        if (mailMessage.pcStateManager == null) {
            mailMessage.icsMethod = string;
            return;
        }
        mailMessage.pcStateManager.settingStringField((PersistenceCapable)mailMessage, pcInheritedFieldCount + 3, mailMessage.icsMethod, string, 0);
    }

    private static final Long pcGetid(MailMessage mailMessage) {
        if (mailMessage.pcStateManager == null) {
            return mailMessage.id;
        }
        int n = pcInheritedFieldCount + 4;
        mailMessage.pcStateManager.accessingField(n);
        return mailMessage.id;
    }

    private static final void pcSetid(MailMessage mailMessage, Long l) {
        if (mailMessage.pcStateManager == null) {
            mailMessage.id = l;
            return;
        }
        mailMessage.pcStateManager.settingObjectField((PersistenceCapable)mailMessage, pcInheritedFieldCount + 4, (Object)mailMessage.id, (Object)l, 0);
    }

    private static final String pcGetlastError(MailMessage mailMessage) {
        if (mailMessage.pcStateManager == null) {
            return mailMessage.lastError;
        }
        int n = pcInheritedFieldCount + 5;
        mailMessage.pcStateManager.accessingField(n);
        return mailMessage.lastError;
    }

    private static final void pcSetlastError(MailMessage mailMessage, String string) {
        if (mailMessage.pcStateManager == null) {
            mailMessage.lastError = string;
            return;
        }
        mailMessage.pcStateManager.settingStringField((PersistenceCapable)mailMessage, pcInheritedFieldCount + 5, mailMessage.lastError, string, 0);
    }

    private static final String pcGetrecipients(MailMessage mailMessage) {
        if (mailMessage.pcStateManager == null) {
            return mailMessage.recipients;
        }
        int n = pcInheritedFieldCount + 6;
        mailMessage.pcStateManager.accessingField(n);
        return mailMessage.recipients;
    }

    private static final void pcSetrecipients(MailMessage mailMessage, String string) {
        if (mailMessage.pcStateManager == null) {
            mailMessage.recipients = string;
            return;
        }
        mailMessage.pcStateManager.settingStringField((PersistenceCapable)mailMessage, pcInheritedFieldCount + 6, mailMessage.recipients, string, 0);
    }

    private static final String pcGetreplyTo(MailMessage mailMessage) {
        if (mailMessage.pcStateManager == null) {
            return mailMessage.replyTo;
        }
        int n = pcInheritedFieldCount + 7;
        mailMessage.pcStateManager.accessingField(n);
        return mailMessage.replyTo;
    }

    private static final void pcSetreplyTo(MailMessage mailMessage, String string) {
        if (mailMessage.pcStateManager == null) {
            mailMessage.replyTo = string;
            return;
        }
        mailMessage.pcStateManager.settingStringField((PersistenceCapable)mailMessage, pcInheritedFieldCount + 7, mailMessage.replyTo, string, 0);
    }

    private static final Status pcGetstatus(MailMessage mailMessage) {
        if (mailMessage.pcStateManager == null) {
            return mailMessage.status;
        }
        int n = pcInheritedFieldCount + 8;
        mailMessage.pcStateManager.accessingField(n);
        return mailMessage.status;
    }

    private static final void pcSetstatus(MailMessage mailMessage, Status status) {
        if (mailMessage.pcStateManager == null) {
            mailMessage.status = status;
            return;
        }
        mailMessage.pcStateManager.settingObjectField((PersistenceCapable)mailMessage, pcInheritedFieldCount + 8, (Object)mailMessage.status, (Object)status, 0);
    }

    private static final String pcGetsubject(MailMessage mailMessage) {
        if (mailMessage.pcStateManager == null) {
            return mailMessage.subject;
        }
        int n = pcInheritedFieldCount + 9;
        mailMessage.pcStateManager.accessingField(n);
        return mailMessage.subject;
    }

    private static final void pcSetsubject(MailMessage mailMessage, String string) {
        if (mailMessage.pcStateManager == null) {
            mailMessage.subject = string;
            return;
        }
        mailMessage.pcStateManager.settingStringField((PersistenceCapable)mailMessage, pcInheritedFieldCount + 9, mailMessage.subject, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    public static enum Status {
        NONE,
        SENDING,
        ERROR,
        DONE;

    }
}

