/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.form.button;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.jquery.core.IJQuerySecurityProvider;
import org.wicketstuff.jquery.ui.form.button.AjaxButton;

public abstract class SecuredAjaxButton
extends AjaxButton {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SecuredAjaxButton.class);
    private String[] roles;
    private final IJQuerySecurityProvider provider;

    public SecuredAjaxButton(String id, String ... roles) {
        this(id, (IJQuerySecurityProvider)WebSession.get(), roles);
    }

    public SecuredAjaxButton(String id, IJQuerySecurityProvider provider, String ... roles) {
        super(id);
        this.roles = roles;
        this.provider = provider;
    }

    public SecuredAjaxButton(String id, Form<?> form, String ... roles) {
        this(id, form, (IJQuerySecurityProvider)WebSession.get(), roles);
    }

    public SecuredAjaxButton(String id, Form<?> form, IJQuerySecurityProvider provider, String ... roles) {
        super(id, form);
        this.roles = roles;
        this.provider = provider;
    }

    public SecuredAjaxButton(String id, IModel<String> model, String ... roles) {
        this(id, model, (IJQuerySecurityProvider)WebSession.get(), roles);
    }

    public SecuredAjaxButton(String id, IModel<String> model, IJQuerySecurityProvider provider, String ... roles) {
        super(id, model);
        this.roles = roles;
        this.provider = provider;
    }

    public SecuredAjaxButton(String id, IModel<String> model, Form<?> form, String ... roles) {
        this(id, model, form, (IJQuerySecurityProvider)WebSession.get(), roles);
    }

    public SecuredAjaxButton(String id, IModel<String> model, Form<?> form, IJQuerySecurityProvider provider, String ... roles) {
        super(id, model, form);
        this.roles = roles;
        this.provider = provider;
    }

    public void setRoles(String[] roles) {
        this.roles = (String[])roles.clone();
    }

    public final boolean isLocked() {
        return !this.provider.hasRole(this.roles);
    }

    @Override
    protected String getIcon() {
        return this.isLocked() ? "ui-icon-locked" : "ui-icon-unlocked";
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setEnabled(!this.isLocked());
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!"button".equalsIgnoreCase(tag.getName())) {
            LOG.warn("SecuredAjaxButton should be applied on a 'button' tag");
        }
    }
}

