<!--
#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
-->

# Library dependencies for openwhisk-wskdeploy tool

Like other open source projects, openwhisk-wskdeploy is dependent on open source libraries. The full list of direct dependencies is viewable in the Go module [go.mod](go.mod) file.  Of those dependencies, some have Apache 2.0 compatible licenses which we make note of here:

| Library name | Licenses Type | License/Project Link |
| ------| ------ | ------ |
| jibber_jabber | Apache 2.0 | [https://github.com/cloudfoundry-attic/jibber_jabber/blob/master/LICENSE](https://github.com/cloudfoundry-attic/jibber_jabber/blob/master/LICENSE) |
| color | MIT | [https://github.com/fatih/color/blob/master/LICENSE.md](https://github.com/fatih/color/blob/master/LICENSE.md) |

# Library dependencies for unit and integration testing

| Library name | Licenses Type | License/Project Link |
| ------| ------ | ------ |
| Testify | MIT | [https://github.com/stretchr/testify/blob/master/LICENSE](https://github.com/stretchr/testify/blob/master/LICENSE) |
| Viper | MIT | [https://github.com/spf13/viper/blob/master/LICENSE](https://github.com/spf13/viper/blob/master/LICENSE) |
