<!--
#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
-->

<!--
********************************
  Normative Reference
********************************
-->
<h2>Normative References</h2>

<table width="100%">
 <tr>
  <th>Tag</th>
  <th>Description</th>
 </tr>
 <tr>
  <td>
  <p>RFC2119</p>
  </td>
  <td>
  <p>S. Bradner, <i>Key words for use in RFCs to Indicate Requirement Levels</i>, <a href="http://www.ietf.org/rfc/rfc2119.txt">http://www.ietf.org/rfc/rfc2119.txt</a>, IETF RFC 2119, March 1997.</p>
  </td>
 </tr>
 <tr>
  <td>
  <p>YAML-1.2</p>
  </td>
  <td>
  <p>YAML, Version 1.2, 3rd Edition, Patched at 2009-10-01, Oren Ben-Kiki, Clark Evans, Ingy dšt Net <a href="http://www.yaml.org/spec/1.2/spec.html">http://www.yaml.org/spec/1.2/spec.html</a></p>
  </td>
 </tr>
 <tr>
  <td>
  <p>YAML-TS-1.1</p>
  </td>
  <td>
  <p>Timestamp Language-Independent Type for YAML Version 1.1, Working Draft 2005-01-18, <a href="http://yaml.org/type/timestamp.html">http://yaml.org/type/timestamp.html</a></p>
  </td>
 </tr>
 <tr>
  <td>
  <p>Maven-Version</p>
  </td>
  <td>
  <p>The version type is defined with the <a href="https://maven.apache.org/index.html">Apache Maven project's</a> policy draft:</p>
  <p><a href="https://cwiki.apache.org/confluence/display/MAVEN/Version+number+policy">https://cwiki.apache.org/confluence/display/MAVEN/Version+number+policy</a></p>
  </td>
 </tr>
 <tr>
  <td>
  <p>OpenAPI-2.0</p>
  </td>
  <td>
  <p>The OpenAPI (f.k.a. 'Swagger') specification for defining REST APIs as JSON.</p>
  <p><a href="https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md">https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md</a></p>
  </td>
 </tr>
 <tr>
  <td>
  <p>Linux-SPDX</p>
  </td>
  <td>
  <p>Linux Foundation, SPDX License list</p>
  <p><a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a></p>
  </td>
 </tr>
 <tr>
  <td>
  <p>NPM-SPDX-Syntax</p>
  </td>
  <td>
  <p>Node Package Manager (NPM) SPDX License Expression Syntax</p>
  <p><a href="https://www.npmjs.com/package/spdx">https://www.npmjs.com/package/spdx</a></p>
  </td>
 </tr>
</table>

<!--
********************************
  Non-normative Reference
********************************
-->

<h2>Non-normative References</h2>

<table width="100%">
 <tr>
  <th>Tag</th>
  <th>Description</th>
 </tr>
 <tr>
  <td>
  <p>OpenWhisk-API</p>
  </td>
  <td>
  <p>OpenWhisk REST API which is defined as an OpenAPI document.</p>
  <p><a href="https://raw.githubusercontent.com/openwhisk/openwhisk/master/core/controller/src/main/resources/whiskswagger.json">https://raw.githubusercontent.com/openwhisk/openwhisk/master/core/controller/src/main/resources/whiskswagger.json</a></p>
  </td>
 </tr>
 <tr>
  <td>
  <p>GNU-units</p>
  </td>
  <td>
  <p>Size-type units are based upon a subset of those defined by GNU at <a href="http://www.gnu.org/software/parted/manual/html_node/unit.html">http://www.gnu.org/software/parted/manual/html_node/unit.html</a></p>
  </td>
 </tr>
 <tr>
  <td>
  <p>RFC 6838</p>
  </td>
  <td>
  <p>Mime Type definitions in compliance with <a href="http://tools.ietf.org/html/rfc6838">RFC 6838</a>.</p>
  </td>
 </tr>
 <tr>
  <td>
  <p>RFC 7231</p>
  </td>
  <td>
  <p>HTTP 1.1. status codes are described in compliance with <a href="http://tools.ietf.org/html/rfc7231#section-6">RFC 7231</a>.</p>
  </td>
 </tr>
 <tr>
  <td>
  <p>IANA-Status-Codes</p>
  </td>
  <td>
  <p>HTTP Status codes as defined in the <a href="http://www.iana.org/assignments/http-status-codes/http-status-codes.xhtml">IANA Status Code Registry</a>.</p>
  </td>
 </tr>
 <tr>
  <td>
  <p>JSON Schema Specification</p>
  </td>
  <td>
  <p>The built-in parameter type 'json' references this specification:
  <a href="http://json-schema.org/">http://json-schema.org/</a></p>
  </td>
 </tr>
</table>
</html>

<!--
 Bottom Navigation
-->
---
<html>
<div align="center">
<a href="../README.md#index">Index</a>
</div>
</html>
