/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApplicationDescription is the corresponding interface of ApplicationDescription
type ApplicationDescription interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetApplicationUri returns ApplicationUri (property field)
	GetApplicationUri() PascalString
	// GetProductUri returns ProductUri (property field)
	GetProductUri() PascalString
	// GetApplicationName returns ApplicationName (property field)
	GetApplicationName() LocalizedText
	// GetApplicationType returns ApplicationType (property field)
	GetApplicationType() ApplicationType
	// GetGatewayServerUri returns GatewayServerUri (property field)
	GetGatewayServerUri() PascalString
	// GetDiscoveryProfileUri returns DiscoveryProfileUri (property field)
	GetDiscoveryProfileUri() PascalString
	// GetDiscoveryUrls returns DiscoveryUrls (property field)
	GetDiscoveryUrls() []PascalString
	// IsApplicationDescription is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApplicationDescription()
	// CreateBuilder creates a ApplicationDescriptionBuilder
	CreateApplicationDescriptionBuilder() ApplicationDescriptionBuilder
}

// _ApplicationDescription is the data-structure of this message
type _ApplicationDescription struct {
	ExtensionObjectDefinitionContract
	ApplicationUri      PascalString
	ProductUri          PascalString
	ApplicationName     LocalizedText
	ApplicationType     ApplicationType
	GatewayServerUri    PascalString
	DiscoveryProfileUri PascalString
	DiscoveryUrls       []PascalString
}

var _ ApplicationDescription = (*_ApplicationDescription)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ApplicationDescription)(nil)

// NewApplicationDescription factory function for _ApplicationDescription
func NewApplicationDescription(applicationUri PascalString, productUri PascalString, applicationName LocalizedText, applicationType ApplicationType, gatewayServerUri PascalString, discoveryProfileUri PascalString, discoveryUrls []PascalString) *_ApplicationDescription {
	if applicationUri == nil {
		panic("applicationUri of type PascalString for ApplicationDescription must not be nil")
	}
	if productUri == nil {
		panic("productUri of type PascalString for ApplicationDescription must not be nil")
	}
	if applicationName == nil {
		panic("applicationName of type LocalizedText for ApplicationDescription must not be nil")
	}
	if gatewayServerUri == nil {
		panic("gatewayServerUri of type PascalString for ApplicationDescription must not be nil")
	}
	if discoveryProfileUri == nil {
		panic("discoveryProfileUri of type PascalString for ApplicationDescription must not be nil")
	}
	_result := &_ApplicationDescription{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		ApplicationUri:                    applicationUri,
		ProductUri:                        productUri,
		ApplicationName:                   applicationName,
		ApplicationType:                   applicationType,
		GatewayServerUri:                  gatewayServerUri,
		DiscoveryProfileUri:               discoveryProfileUri,
		DiscoveryUrls:                     discoveryUrls,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApplicationDescriptionBuilder is a builder for ApplicationDescription
type ApplicationDescriptionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(applicationUri PascalString, productUri PascalString, applicationName LocalizedText, applicationType ApplicationType, gatewayServerUri PascalString, discoveryProfileUri PascalString, discoveryUrls []PascalString) ApplicationDescriptionBuilder
	// WithApplicationUri adds ApplicationUri (property field)
	WithApplicationUri(PascalString) ApplicationDescriptionBuilder
	// WithApplicationUriBuilder adds ApplicationUri (property field) which is build by the builder
	WithApplicationUriBuilder(func(PascalStringBuilder) PascalStringBuilder) ApplicationDescriptionBuilder
	// WithProductUri adds ProductUri (property field)
	WithProductUri(PascalString) ApplicationDescriptionBuilder
	// WithProductUriBuilder adds ProductUri (property field) which is build by the builder
	WithProductUriBuilder(func(PascalStringBuilder) PascalStringBuilder) ApplicationDescriptionBuilder
	// WithApplicationName adds ApplicationName (property field)
	WithApplicationName(LocalizedText) ApplicationDescriptionBuilder
	// WithApplicationNameBuilder adds ApplicationName (property field) which is build by the builder
	WithApplicationNameBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) ApplicationDescriptionBuilder
	// WithApplicationType adds ApplicationType (property field)
	WithApplicationType(ApplicationType) ApplicationDescriptionBuilder
	// WithGatewayServerUri adds GatewayServerUri (property field)
	WithGatewayServerUri(PascalString) ApplicationDescriptionBuilder
	// WithGatewayServerUriBuilder adds GatewayServerUri (property field) which is build by the builder
	WithGatewayServerUriBuilder(func(PascalStringBuilder) PascalStringBuilder) ApplicationDescriptionBuilder
	// WithDiscoveryProfileUri adds DiscoveryProfileUri (property field)
	WithDiscoveryProfileUri(PascalString) ApplicationDescriptionBuilder
	// WithDiscoveryProfileUriBuilder adds DiscoveryProfileUri (property field) which is build by the builder
	WithDiscoveryProfileUriBuilder(func(PascalStringBuilder) PascalStringBuilder) ApplicationDescriptionBuilder
	// WithDiscoveryUrls adds DiscoveryUrls (property field)
	WithDiscoveryUrls(...PascalString) ApplicationDescriptionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ApplicationDescription or returns an error if something is wrong
	Build() (ApplicationDescription, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApplicationDescription
}

// NewApplicationDescriptionBuilder() creates a ApplicationDescriptionBuilder
func NewApplicationDescriptionBuilder() ApplicationDescriptionBuilder {
	return &_ApplicationDescriptionBuilder{_ApplicationDescription: new(_ApplicationDescription)}
}

type _ApplicationDescriptionBuilder struct {
	*_ApplicationDescription

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (ApplicationDescriptionBuilder) = (*_ApplicationDescriptionBuilder)(nil)

func (b *_ApplicationDescriptionBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ApplicationDescription
}

func (b *_ApplicationDescriptionBuilder) WithMandatoryFields(applicationUri PascalString, productUri PascalString, applicationName LocalizedText, applicationType ApplicationType, gatewayServerUri PascalString, discoveryProfileUri PascalString, discoveryUrls []PascalString) ApplicationDescriptionBuilder {
	return b.WithApplicationUri(applicationUri).WithProductUri(productUri).WithApplicationName(applicationName).WithApplicationType(applicationType).WithGatewayServerUri(gatewayServerUri).WithDiscoveryProfileUri(discoveryProfileUri).WithDiscoveryUrls(discoveryUrls...)
}

func (b *_ApplicationDescriptionBuilder) WithApplicationUri(applicationUri PascalString) ApplicationDescriptionBuilder {
	b.ApplicationUri = applicationUri
	return b
}

func (b *_ApplicationDescriptionBuilder) WithApplicationUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ApplicationDescriptionBuilder {
	builder := builderSupplier(b.ApplicationUri.CreatePascalStringBuilder())
	var err error
	b.ApplicationUri, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ApplicationDescriptionBuilder) WithProductUri(productUri PascalString) ApplicationDescriptionBuilder {
	b.ProductUri = productUri
	return b
}

func (b *_ApplicationDescriptionBuilder) WithProductUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ApplicationDescriptionBuilder {
	builder := builderSupplier(b.ProductUri.CreatePascalStringBuilder())
	var err error
	b.ProductUri, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ApplicationDescriptionBuilder) WithApplicationName(applicationName LocalizedText) ApplicationDescriptionBuilder {
	b.ApplicationName = applicationName
	return b
}

func (b *_ApplicationDescriptionBuilder) WithApplicationNameBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) ApplicationDescriptionBuilder {
	builder := builderSupplier(b.ApplicationName.CreateLocalizedTextBuilder())
	var err error
	b.ApplicationName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_ApplicationDescriptionBuilder) WithApplicationType(applicationType ApplicationType) ApplicationDescriptionBuilder {
	b.ApplicationType = applicationType
	return b
}

func (b *_ApplicationDescriptionBuilder) WithGatewayServerUri(gatewayServerUri PascalString) ApplicationDescriptionBuilder {
	b.GatewayServerUri = gatewayServerUri
	return b
}

func (b *_ApplicationDescriptionBuilder) WithGatewayServerUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ApplicationDescriptionBuilder {
	builder := builderSupplier(b.GatewayServerUri.CreatePascalStringBuilder())
	var err error
	b.GatewayServerUri, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ApplicationDescriptionBuilder) WithDiscoveryProfileUri(discoveryProfileUri PascalString) ApplicationDescriptionBuilder {
	b.DiscoveryProfileUri = discoveryProfileUri
	return b
}

func (b *_ApplicationDescriptionBuilder) WithDiscoveryProfileUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ApplicationDescriptionBuilder {
	builder := builderSupplier(b.DiscoveryProfileUri.CreatePascalStringBuilder())
	var err error
	b.DiscoveryProfileUri, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ApplicationDescriptionBuilder) WithDiscoveryUrls(discoveryUrls ...PascalString) ApplicationDescriptionBuilder {
	b.DiscoveryUrls = discoveryUrls
	return b
}

func (b *_ApplicationDescriptionBuilder) Build() (ApplicationDescription, error) {
	if b.ApplicationUri == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'applicationUri' not set"))
	}
	if b.ProductUri == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'productUri' not set"))
	}
	if b.ApplicationName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'applicationName' not set"))
	}
	if b.GatewayServerUri == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'gatewayServerUri' not set"))
	}
	if b.DiscoveryProfileUri == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'discoveryProfileUri' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ApplicationDescription.deepCopy(), nil
}

func (b *_ApplicationDescriptionBuilder) MustBuild() ApplicationDescription {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApplicationDescriptionBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ApplicationDescriptionBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ApplicationDescriptionBuilder) DeepCopy() any {
	_copy := b.CreateApplicationDescriptionBuilder().(*_ApplicationDescriptionBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateApplicationDescriptionBuilder creates a ApplicationDescriptionBuilder
func (b *_ApplicationDescription) CreateApplicationDescriptionBuilder() ApplicationDescriptionBuilder {
	if b == nil {
		return NewApplicationDescriptionBuilder()
	}
	return &_ApplicationDescriptionBuilder{_ApplicationDescription: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApplicationDescription) GetExtensionId() int32 {
	return int32(310)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApplicationDescription) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ApplicationDescription) GetApplicationUri() PascalString {
	return m.ApplicationUri
}

func (m *_ApplicationDescription) GetProductUri() PascalString {
	return m.ProductUri
}

func (m *_ApplicationDescription) GetApplicationName() LocalizedText {
	return m.ApplicationName
}

func (m *_ApplicationDescription) GetApplicationType() ApplicationType {
	return m.ApplicationType
}

func (m *_ApplicationDescription) GetGatewayServerUri() PascalString {
	return m.GatewayServerUri
}

func (m *_ApplicationDescription) GetDiscoveryProfileUri() PascalString {
	return m.DiscoveryProfileUri
}

func (m *_ApplicationDescription) GetDiscoveryUrls() []PascalString {
	return m.DiscoveryUrls
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastApplicationDescription(structType any) ApplicationDescription {
	if casted, ok := structType.(ApplicationDescription); ok {
		return casted
	}
	if casted, ok := structType.(*ApplicationDescription); ok {
		return *casted
	}
	return nil
}

func (m *_ApplicationDescription) GetTypeName() string {
	return "ApplicationDescription"
}

func (m *_ApplicationDescription) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (applicationUri)
	lengthInBits += m.ApplicationUri.GetLengthInBits(ctx)

	// Simple field (productUri)
	lengthInBits += m.ProductUri.GetLengthInBits(ctx)

	// Simple field (applicationName)
	lengthInBits += m.ApplicationName.GetLengthInBits(ctx)

	// Simple field (applicationType)
	lengthInBits += 32

	// Simple field (gatewayServerUri)
	lengthInBits += m.GatewayServerUri.GetLengthInBits(ctx)

	// Simple field (discoveryProfileUri)
	lengthInBits += m.DiscoveryProfileUri.GetLengthInBits(ctx)

	// Implicit Field (noOfDiscoveryUrls)
	lengthInBits += 32

	// Array field
	if len(m.DiscoveryUrls) > 0 {
		for _curItem, element := range m.DiscoveryUrls {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.DiscoveryUrls), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_ApplicationDescription) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApplicationDescription) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__applicationDescription ApplicationDescription, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApplicationDescription"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApplicationDescription")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	applicationUri, err := ReadSimpleField[PascalString](ctx, "applicationUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'applicationUri' field"))
	}
	m.ApplicationUri = applicationUri

	productUri, err := ReadSimpleField[PascalString](ctx, "productUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'productUri' field"))
	}
	m.ProductUri = productUri

	applicationName, err := ReadSimpleField[LocalizedText](ctx, "applicationName", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'applicationName' field"))
	}
	m.ApplicationName = applicationName

	applicationType, err := ReadEnumField[ApplicationType](ctx, "applicationType", "ApplicationType", ReadEnum(ApplicationTypeByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'applicationType' field"))
	}
	m.ApplicationType = applicationType

	gatewayServerUri, err := ReadSimpleField[PascalString](ctx, "gatewayServerUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'gatewayServerUri' field"))
	}
	m.GatewayServerUri = gatewayServerUri

	discoveryProfileUri, err := ReadSimpleField[PascalString](ctx, "discoveryProfileUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'discoveryProfileUri' field"))
	}
	m.DiscoveryProfileUri = discoveryProfileUri

	noOfDiscoveryUrls, err := ReadImplicitField[int32](ctx, "noOfDiscoveryUrls", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfDiscoveryUrls' field"))
	}
	_ = noOfDiscoveryUrls

	discoveryUrls, err := ReadCountArrayField[PascalString](ctx, "discoveryUrls", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfDiscoveryUrls))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'discoveryUrls' field"))
	}
	m.DiscoveryUrls = discoveryUrls

	if closeErr := readBuffer.CloseContext("ApplicationDescription"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApplicationDescription")
	}

	return m, nil
}

func (m *_ApplicationDescription) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApplicationDescription) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApplicationDescription"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApplicationDescription")
		}

		if err := WriteSimpleField[PascalString](ctx, "applicationUri", m.GetApplicationUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'applicationUri' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "productUri", m.GetProductUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'productUri' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "applicationName", m.GetApplicationName(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'applicationName' field")
		}

		if err := WriteSimpleEnumField[ApplicationType](ctx, "applicationType", "ApplicationType", m.GetApplicationType(), WriteEnum[ApplicationType, uint32](ApplicationType.GetValue, ApplicationType.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'applicationType' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "gatewayServerUri", m.GetGatewayServerUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'gatewayServerUri' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "discoveryProfileUri", m.GetDiscoveryProfileUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'discoveryProfileUri' field")
		}
		noOfDiscoveryUrls := int32(utils.InlineIf(bool((m.GetDiscoveryUrls()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetDiscoveryUrls()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfDiscoveryUrls", noOfDiscoveryUrls, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfDiscoveryUrls' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "discoveryUrls", m.GetDiscoveryUrls(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'discoveryUrls' field")
		}

		if popErr := writeBuffer.PopContext("ApplicationDescription"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApplicationDescription")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApplicationDescription) IsApplicationDescription() {}

func (m *_ApplicationDescription) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApplicationDescription) deepCopy() *_ApplicationDescription {
	if m == nil {
		return nil
	}
	_ApplicationDescriptionCopy := &_ApplicationDescription{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.ApplicationUri),
		utils.DeepCopy[PascalString](m.ProductUri),
		utils.DeepCopy[LocalizedText](m.ApplicationName),
		m.ApplicationType,
		utils.DeepCopy[PascalString](m.GatewayServerUri),
		utils.DeepCopy[PascalString](m.DiscoveryProfileUri),
		utils.DeepCopySlice[PascalString, PascalString](m.DiscoveryUrls),
	}
	_ApplicationDescriptionCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ApplicationDescriptionCopy
}

func (m *_ApplicationDescription) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
