/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetAccumulatorRecord implements Message {

  // Properties.
  protected final BACnetDateTimeEnclosed timestamp;
  protected final BACnetContextTagSignedInteger presentValue;
  protected final BACnetContextTagSignedInteger accumulatedValue;
  protected final BACnetAccumulatorRecordAccumulatorStatusTagged accumulatorStatus;

  public BACnetAccumulatorRecord(
      BACnetDateTimeEnclosed timestamp,
      BACnetContextTagSignedInteger presentValue,
      BACnetContextTagSignedInteger accumulatedValue,
      BACnetAccumulatorRecordAccumulatorStatusTagged accumulatorStatus) {
    super();
    this.timestamp = timestamp;
    this.presentValue = presentValue;
    this.accumulatedValue = accumulatedValue;
    this.accumulatorStatus = accumulatorStatus;
  }

  public BACnetDateTimeEnclosed getTimestamp() {
    return timestamp;
  }

  public BACnetContextTagSignedInteger getPresentValue() {
    return presentValue;
  }

  public BACnetContextTagSignedInteger getAccumulatedValue() {
    return accumulatedValue;
  }

  public BACnetAccumulatorRecordAccumulatorStatusTagged getAccumulatorStatus() {
    return accumulatorStatus;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetAccumulatorRecord");

    // Simple Field (timestamp)
    writeSimpleField("timestamp", timestamp, writeComplex(writeBuffer));

    // Simple Field (presentValue)
    writeSimpleField("presentValue", presentValue, writeComplex(writeBuffer));

    // Simple Field (accumulatedValue)
    writeSimpleField("accumulatedValue", accumulatedValue, writeComplex(writeBuffer));

    // Simple Field (accumulatorStatus)
    writeSimpleField("accumulatorStatus", accumulatorStatus, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetAccumulatorRecord");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetAccumulatorRecord _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (timestamp)
    lengthInBits += timestamp.getLengthInBits();

    // Simple field (presentValue)
    lengthInBits += presentValue.getLengthInBits();

    // Simple field (accumulatedValue)
    lengthInBits += accumulatedValue.getLengthInBits();

    // Simple field (accumulatorStatus)
    lengthInBits += accumulatorStatus.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetAccumulatorRecord staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetAccumulatorRecord");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetDateTimeEnclosed timestamp =
        readSimpleField(
            "timestamp",
            readComplex(
                () -> BACnetDateTimeEnclosed.staticParse(readBuffer, (short) (0)), readBuffer));

    BACnetContextTagSignedInteger presentValue =
        readSimpleField(
            "presentValue",
            readComplex(
                () ->
                    (BACnetContextTagSignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (1),
                            (BACnetDataType) (BACnetDataType.SIGNED_INTEGER)),
                readBuffer));

    BACnetContextTagSignedInteger accumulatedValue =
        readSimpleField(
            "accumulatedValue",
            readComplex(
                () ->
                    (BACnetContextTagSignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (2),
                            (BACnetDataType) (BACnetDataType.SIGNED_INTEGER)),
                readBuffer));

    BACnetAccumulatorRecordAccumulatorStatusTagged accumulatorStatus =
        readSimpleField(
            "accumulatorStatus",
            readComplex(
                () ->
                    BACnetAccumulatorRecordAccumulatorStatusTagged.staticParse(
                        readBuffer, (short) (3), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    readBuffer.closeContext("BACnetAccumulatorRecord");
    // Create the instance
    BACnetAccumulatorRecord _bACnetAccumulatorRecord;
    _bACnetAccumulatorRecord =
        new BACnetAccumulatorRecord(timestamp, presentValue, accumulatedValue, accumulatorStatus);
    return _bACnetAccumulatorRecord;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetAccumulatorRecord)) {
      return false;
    }
    BACnetAccumulatorRecord that = (BACnetAccumulatorRecord) o;
    return (getTimestamp() == that.getTimestamp())
        && (getPresentValue() == that.getPresentValue())
        && (getAccumulatedValue() == that.getAccumulatedValue())
        && (getAccumulatorStatus() == that.getAccumulatorStatus())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getTimestamp(), getPresentValue(), getAccumulatedValue(), getAccumulatorStatus());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
