/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetTagPayloadObjectIdentifier implements Message {

  // Properties.
  protected final BACnetObjectType objectType;
  protected final short proprietaryValue;
  protected final int instanceNumber;

  public BACnetTagPayloadObjectIdentifier(
      BACnetObjectType objectType, short proprietaryValue, int instanceNumber) {
    super();
    this.objectType = objectType;
    this.proprietaryValue = proprietaryValue;
    this.instanceNumber = instanceNumber;
  }

  public BACnetObjectType getObjectType() {
    return objectType;
  }

  public short getProprietaryValue() {
    return proprietaryValue;
  }

  public int getInstanceNumber() {
    return instanceNumber;
  }

  public boolean getIsProprietary() {
    return (boolean) ((getObjectType()) == (BACnetObjectType.VENDOR_PROPRIETARY_VALUE));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetTagPayloadObjectIdentifier");

    // Manual Field (objectType)
    writeManualField(
        "objectType",
        () ->
            org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper.writeObjectType(
                writeBuffer, objectType),
        writeBuffer);

    // Manual Field (proprietaryValue)
    writeManualField(
        "proprietaryValue",
        () ->
            org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper.writeProprietaryObjectType(
                writeBuffer, objectType, proprietaryValue),
        writeBuffer);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isProprietary = getIsProprietary();
    writeBuffer.writeVirtual("isProprietary", isProprietary);

    // Simple Field (instanceNumber)
    writeSimpleField("instanceNumber", instanceNumber, writeUnsignedInt(writeBuffer, 22));

    writeBuffer.popContext("BACnetTagPayloadObjectIdentifier");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetTagPayloadObjectIdentifier _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Manual Field (objectType)
    lengthInBits += 10;

    // Manual Field (proprietaryValue)
    lengthInBits += 0;

    // A virtual field doesn't have any in- or output.

    // Simple field (instanceNumber)
    lengthInBits += 22;

    return lengthInBits;
  }

  public static BACnetTagPayloadObjectIdentifier staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BACnetTagPayloadObjectIdentifier");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetObjectType objectType =
        readManualField(
            "objectType",
            readBuffer,
            () ->
                (BACnetObjectType)
                    (org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper.readObjectType(
                        readBuffer)));

    short proprietaryValue =
        readManualField(
            "proprietaryValue",
            readBuffer,
            () ->
                (short)
                    (org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper
                        .readProprietaryObjectType(readBuffer, objectType)));
    boolean isProprietary =
        readVirtualField(
            "isProprietary",
            boolean.class,
            (objectType) == (BACnetObjectType.VENDOR_PROPRIETARY_VALUE));

    int instanceNumber = readSimpleField("instanceNumber", readUnsignedInt(readBuffer, 22));

    readBuffer.closeContext("BACnetTagPayloadObjectIdentifier");
    // Create the instance
    BACnetTagPayloadObjectIdentifier _bACnetTagPayloadObjectIdentifier;
    _bACnetTagPayloadObjectIdentifier =
        new BACnetTagPayloadObjectIdentifier(objectType, proprietaryValue, instanceNumber);
    return _bACnetTagPayloadObjectIdentifier;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetTagPayloadObjectIdentifier)) {
      return false;
    }
    BACnetTagPayloadObjectIdentifier that = (BACnetTagPayloadObjectIdentifier) o;
    return (getObjectType() == that.getObjectType())
        && (getProprietaryValue() == that.getProprietaryValue())
        && (getInstanceNumber() == that.getInstanceNumber())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getObjectType(), getProprietaryValue(), getInstanceNumber());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
