/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BaseConfigurationDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15436;
  }

  // Properties.
  protected final long configurationVersion;
  protected final List<KeyValuePair> configurationProperties;

  public BaseConfigurationDataType(
      long configurationVersion, List<KeyValuePair> configurationProperties) {
    super();
    this.configurationVersion = configurationVersion;
    this.configurationProperties = configurationProperties;
  }

  public long getConfigurationVersion() {
    return configurationVersion;
  }

  public List<KeyValuePair> getConfigurationProperties() {
    return configurationProperties;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BaseConfigurationDataType");

    // Simple Field (configurationVersion)
    writeSimpleField(
        "configurationVersion", configurationVersion, writeUnsignedLong(writeBuffer, 32));

    // Implicit Field (noOfConfigurationProperties) (Used for parsing, but its value is not stored
    // as it's implicitly given by the objects content)
    int noOfConfigurationProperties =
        (int)
            ((((getConfigurationProperties()) == (null))
                ? -(1)
                : COUNT(getConfigurationProperties())));
    writeImplicitField(
        "noOfConfigurationProperties",
        noOfConfigurationProperties,
        writeSignedInt(writeBuffer, 32));

    // Array Field (configurationProperties)
    writeComplexTypeArrayField("configurationProperties", configurationProperties, writeBuffer);

    writeBuffer.popContext("BaseConfigurationDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BaseConfigurationDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (configurationVersion)
    lengthInBits += 32;

    // Implicit Field (noOfConfigurationProperties)
    lengthInBits += 32;

    // Array field
    if (configurationProperties != null) {
      int i = 0;
      for (KeyValuePair element : configurationProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= configurationProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("BaseConfigurationDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long configurationVersion =
        readSimpleField("configurationVersion", readUnsignedLong(readBuffer, 32));

    int noOfConfigurationProperties =
        readImplicitField("noOfConfigurationProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> configurationProperties =
        readCountArrayField(
            "configurationProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfConfigurationProperties);

    readBuffer.closeContext("BaseConfigurationDataType");
    // Create the instance
    return new BaseConfigurationDataTypeBuilderImpl(configurationVersion, configurationProperties);
  }

  public static class BaseConfigurationDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final long configurationVersion;
    private final List<KeyValuePair> configurationProperties;

    public BaseConfigurationDataTypeBuilderImpl(
        long configurationVersion, List<KeyValuePair> configurationProperties) {
      this.configurationVersion = configurationVersion;
      this.configurationProperties = configurationProperties;
    }

    public BaseConfigurationDataType build() {
      BaseConfigurationDataType baseConfigurationDataType =
          new BaseConfigurationDataType(configurationVersion, configurationProperties);
      return baseConfigurationDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BaseConfigurationDataType)) {
      return false;
    }
    BaseConfigurationDataType that = (BaseConfigurationDataType) o;
    return (getConfigurationVersion() == that.getConfigurationVersion())
        && (getConfigurationProperties() == that.getConfigurationProperties())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getConfigurationVersion(), getConfigurationProperties());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
