/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class JsonDataSetReaderMessageDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15667;
  }

  // Properties.
  protected final JsonNetworkMessageContentMask networkMessageContentMask;
  protected final JsonDataSetMessageContentMask dataSetMessageContentMask;

  public JsonDataSetReaderMessageDataType(
      JsonNetworkMessageContentMask networkMessageContentMask,
      JsonDataSetMessageContentMask dataSetMessageContentMask) {
    super();
    this.networkMessageContentMask = networkMessageContentMask;
    this.dataSetMessageContentMask = dataSetMessageContentMask;
  }

  public JsonNetworkMessageContentMask getNetworkMessageContentMask() {
    return networkMessageContentMask;
  }

  public JsonDataSetMessageContentMask getDataSetMessageContentMask() {
    return dataSetMessageContentMask;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("JsonDataSetReaderMessageDataType");

    // Simple Field (networkMessageContentMask)
    writeSimpleEnumField(
        "networkMessageContentMask",
        "JsonNetworkMessageContentMask",
        networkMessageContentMask,
        writeEnum(
            JsonNetworkMessageContentMask::getValue,
            JsonNetworkMessageContentMask::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (dataSetMessageContentMask)
    writeSimpleEnumField(
        "dataSetMessageContentMask",
        "JsonDataSetMessageContentMask",
        dataSetMessageContentMask,
        writeEnum(
            JsonDataSetMessageContentMask::getValue,
            JsonDataSetMessageContentMask::name,
            writeUnsignedLong(writeBuffer, 32)));

    writeBuffer.popContext("JsonDataSetReaderMessageDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    JsonDataSetReaderMessageDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (networkMessageContentMask)
    lengthInBits += 32;

    // Simple field (dataSetMessageContentMask)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("JsonDataSetReaderMessageDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    JsonNetworkMessageContentMask networkMessageContentMask =
        readEnumField(
            "networkMessageContentMask",
            "JsonNetworkMessageContentMask",
            readEnum(
                JsonNetworkMessageContentMask::enumForValue, readUnsignedLong(readBuffer, 32)));

    JsonDataSetMessageContentMask dataSetMessageContentMask =
        readEnumField(
            "dataSetMessageContentMask",
            "JsonDataSetMessageContentMask",
            readEnum(
                JsonDataSetMessageContentMask::enumForValue, readUnsignedLong(readBuffer, 32)));

    readBuffer.closeContext("JsonDataSetReaderMessageDataType");
    // Create the instance
    return new JsonDataSetReaderMessageDataTypeBuilderImpl(
        networkMessageContentMask, dataSetMessageContentMask);
  }

  public static class JsonDataSetReaderMessageDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final JsonNetworkMessageContentMask networkMessageContentMask;
    private final JsonDataSetMessageContentMask dataSetMessageContentMask;

    public JsonDataSetReaderMessageDataTypeBuilderImpl(
        JsonNetworkMessageContentMask networkMessageContentMask,
        JsonDataSetMessageContentMask dataSetMessageContentMask) {
      this.networkMessageContentMask = networkMessageContentMask;
      this.dataSetMessageContentMask = dataSetMessageContentMask;
    }

    public JsonDataSetReaderMessageDataType build() {
      JsonDataSetReaderMessageDataType jsonDataSetReaderMessageDataType =
          new JsonDataSetReaderMessageDataType(
              networkMessageContentMask, dataSetMessageContentMask);
      return jsonDataSetReaderMessageDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof JsonDataSetReaderMessageDataType)) {
      return false;
    }
    JsonDataSetReaderMessageDataType that = (JsonDataSetReaderMessageDataType) o;
    return (getNetworkMessageContentMask() == that.getNetworkMessageContentMask())
        && (getDataSetMessageContentMask() == that.getDataSetMessageContentMask())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getNetworkMessageContentMask(), getDataSetMessageContentMask());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
