/*
 * Decompiled with CFR 0.152.
 */
package com.scurrilous.circe.crc;

import com.scurrilous.circe.StatefulHash;
import com.scurrilous.circe.StatefulIntHash;
import com.scurrilous.circe.StatelessIntHash;
import com.scurrilous.circe.impl.AbstractStatefulHash;
import com.scurrilous.circe.impl.AbstractStatelessIntHash;
import com.scurrilous.circe.params.CrcParameters;
import java.util.zip.CRC32;

final class JavaCrc32
extends AbstractStatefulHash
implements StatefulIntHash {
    private static final String ALGORITHM = CrcParameters.CRC32.algorithm();
    private static final int LENGTH = 4;
    private final CRC32 impl = new CRC32();

    JavaCrc32() {
    }

    @Override
    public String algorithm() {
        return ALGORITHM;
    }

    @Override
    public int length() {
        return 4;
    }

    @Override
    public StatefulHash createNew() {
        return new JavaCrc32();
    }

    @Override
    public boolean supportsIncremental() {
        return true;
    }

    @Override
    public void reset() {
        this.impl.reset();
    }

    @Override
    protected void updateUnchecked(byte[] input, int index, int length) {
        this.impl.update(input, index, length);
    }

    @Override
    public int getInt() {
        return (int)this.impl.getValue();
    }

    @Override
    public long getLong() {
        return this.impl.getValue();
    }

    @Override
    public StatelessIntHash asStateless() {
        return new AbstractStatelessIntHash(){

            @Override
            public String algorithm() {
                return ALGORITHM;
            }

            @Override
            public int length() {
                return 4;
            }

            @Override
            public StatefulIntHash createStateful() {
                return new JavaCrc32();
            }

            @Override
            protected int calculateUnchecked(byte[] input, int index, int length) {
                CRC32 crc32 = new CRC32();
                crc32.update(input, index, length);
                return (int)crc32.getValue();
            }
        };
    }
}

