/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.arithmetic;

import java.math.BigDecimal;
import java.util.Objects;
import org.apache.qpid.server.query.engine.evaluator.settings.QuerySettings;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.arithmetic.AbstractArithmeticExpression;
import org.apache.qpid.server.query.engine.parsing.expression.literal.ConstantExpression;
import org.apache.qpid.server.query.engine.parsing.utils.StringUtils;

public class DivideExpression<T, R>
extends AbstractArithmeticExpression<T, R> {
    public DivideExpression(String alias, ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        super(alias, left, right);
        if (right instanceof ConstantExpression && Objects.equals(0, ((ConstantExpression)right).get())) {
            throw QueryParsingException.of("Divisor is equal to zero", new Object[0]);
        }
    }

    @Override
    public R apply(T value) {
        Object arg1 = this.evaluateChild(0, value);
        Object arg2 = this.evaluateChild(1, value);
        if (arg1 == null || arg2 == null) {
            return null;
        }
        if (!(arg1 instanceof Number) || !(arg2 instanceof Number)) {
            throw QueryParsingException.of("Operator '%s' doesn't support arguments '%s' of type '%s' and '%s' of type '%s'", "/", arg1, StringUtils.getClassName(arg1), arg2, StringUtils.getClassName(arg2));
        }
        if (Objects.equals(0, arg2)) {
            throw QueryParsingException.of("Divisor is equal to zero", new Object[0]);
        }
        QuerySettings querySettings = (QuerySettings)this.ctx().get("query.settings");
        BigDecimal result = new BigDecimal(arg1.toString()).divide(new BigDecimal(arg2.toString()), querySettings.getDecimalDigits(), querySettings.getRoundingMode());
        return NumberConverter.narrow(result);
    }
}

