/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.config;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.user.connection.limits.config.ConnectionLimits;

final class ConnectionLimitsImpl
implements ConnectionLimits {
    private final Integer _connectionCount;
    private final Map<Duration, Integer> _connectionFrequency;

    ConnectionLimitsImpl(ConnectionLimits first, ConnectionLimits second) {
        this._connectionCount = ConnectionLimitsImpl.min(first.getCountLimit(), second.getCountLimit());
        this._connectionFrequency = new HashMap<Duration, Integer>(first.getFrequencyLimits());
        second.getFrequencyLimits().forEach((duration, limit) -> this._connectionFrequency.merge((Duration)duration, (Integer)limit, ConnectionLimitsImpl::min));
        if (this._connectionCount == null && this._connectionFrequency.isEmpty()) {
            throw new IllegalArgumentException("Unexpected empty limits");
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Integer getCountLimit() {
        return this._connectionCount;
    }

    @Override
    public Map<Duration, Integer> getFrequencyLimits() {
        return Collections.unmodifiableMap(this._connectionFrequency);
    }

    @Override
    public boolean isUserBlocked() {
        return false;
    }

    static Integer min(Integer first, Integer second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return Math.min(first, second);
    }
}

