/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.extensions.soleconn;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.qpid.server.protocol.v1_0.AMQPConnection_1_0;
import org.apache.qpid.server.protocol.v1_0.type.extensions.soleconn.SoleConnectionEnforcementPolicy;
import org.apache.qpid.server.security.limit.ConnectionLimitException;

public class SoleConnectionEnforcementPolicyException
extends ConnectionLimitException {
    private static final String MESSAGE = "Single connection with container ID '%s' is required due to sole connection enforcement policy '%s'";
    private final Set<AMQPConnection_1_0<?>> _existingConnections;
    private final SoleConnectionEnforcementPolicy _policy;
    private final String _containerID;

    public SoleConnectionEnforcementPolicyException(SoleConnectionEnforcementPolicy policy, Collection<? extends AMQPConnection_1_0<?>> connections, String containerID) {
        super(String.format(MESSAGE, containerID, policy));
        this._policy = Objects.requireNonNull(policy);
        this._existingConnections = new HashSet(connections);
        this._containerID = Objects.requireNonNull(containerID);
    }

    public SoleConnectionEnforcementPolicy getPolicy() {
        return this._policy;
    }

    public Set<AMQPConnection_1_0<?>> getExistingConnections() {
        return Collections.unmodifiableSet(this._existingConnections);
    }

    public String getContainerID() {
        return this._containerID;
    }
}

