/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;

public final class DRDAServerStarter
implements ModuleControl,
Runnable {
    private Object server;
    private Method runServerMethod;
    private Method serverShutdownMethod;
    private Thread serverThread;
    private static final String serverClassName = "org.apache.derby.impl.drda.NetworkServerControlImpl";
    private Class<?> serverClass;
    private InetAddress listenAddress = null;
    private int portNumber = -1;
    private String userArg = null;
    private String passwordArg = null;
    private PrintWriter consoleWriter = null;

    public void setStartInfo(InetAddress inetAddress, int n, String string, String string2, PrintWriter printWriter) {
        this.userArg = string;
        this.passwordArg = string2;
        this.setStartInfo(inetAddress, n, printWriter);
    }

    public void setStartInfo(InetAddress inetAddress, int n, PrintWriter printWriter) {
        this.listenAddress = inetAddress;
        this.portNumber = n;
        this.consoleWriter = printWriter != null ? new PrintWriter((Writer)printWriter, true) : printWriter;
    }

    private void findStartStopMethods(Class<?> clazz) throws NoSuchMethodException {
        this.runServerMethod = clazz.getMethod("blockingStart", PrintWriter.class);
        this.serverShutdownMethod = clazz.getMethod("directShutdown", null);
    }

    @Override
    public void boot(boolean bl, Properties properties) {
        if (this.server != null) {
            return;
        }
        try {
            this.serverClass = Class.forName(serverClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Monitor.logTextMessage("J100", serverClassName);
            return;
        }
        catch (Error error) {
            Monitor.logTextMessage("J101", serverClassName, error.getMessage());
            return;
        }
        try {
            Constructor<?> constructor;
            try {
                constructor = this.listenAddress == null ? this.serverClass.getConstructor(String.class, String.class) : this.serverClass.getConstructor(InetAddress.class, Integer.TYPE, String.class, String.class);
            }
            catch (Exception exception) {
                Monitor.logTextMessage("J102", exception.getMessage());
                exception.printStackTrace(Monitor.getStream().getPrintWriter());
                return;
            }
            this.findStartStopMethods(this.serverClass);
            this.server = this.listenAddress == null ? constructor.newInstance(this.userArg, this.passwordArg) : constructor.newInstance(this.listenAddress, this.portNumber, this.userArg, this.passwordArg);
            this.serverThread = DRDAServerStarter.getMonitor().getDaemonThread(this, "NetworkServerStarter", false);
            this.serverThread.start();
        }
        catch (Exception exception) {
            Monitor.logTextMessage("J102", exception.getMessage());
            this.server = null;
            exception.printStackTrace(Monitor.getStream().getPrintWriter());
        }
    }

    @Override
    public void run() {
        try {
            this.runServerMethod.invoke(this.server, this.consoleWriter);
        }
        catch (InvocationTargetException invocationTargetException) {
            Monitor.logTextMessage("J102", invocationTargetException.getTargetException().getMessage());
            invocationTargetException.printStackTrace(Monitor.getStream().getPrintWriter());
            this.server = null;
        }
        catch (Exception exception) {
            Monitor.logTextMessage("J102", exception.getMessage());
            this.server = null;
            exception.printStackTrace(Monitor.getStream().getPrintWriter());
        }
    }

    @Override
    public void stop() {
        try {
            if (this.serverThread != null && this.serverThread.isAlive()) {
                this.serverShutdownMethod.invoke(this.server, null);
                this.serverThread.interrupt();
                this.serverThread = null;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Monitor.logTextMessage("J103", invocationTargetException.getTargetException().getMessage());
            invocationTargetException.printStackTrace(Monitor.getStream().getPrintWriter());
        }
        catch (Exception exception) {
            Monitor.logTextMessage("J103", exception.getMessage());
            exception.printStackTrace(Monitor.getStream().getPrintWriter());
        }
        this.serverThread = null;
        this.server = null;
        this.serverClass = null;
        this.listenAddress = null;
        this.portNumber = -1;
        this.consoleWriter = null;
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }
}

