/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.util;

public class SequenceNumber
extends Number
implements Comparable<SequenceNumber> {
    private static final long serialVersionUID = -1337181254740481576L;
    private int sequence;

    public SequenceNumber(int startValue) {
        this.sequence = startValue;
    }

    public SequenceNumber increment() {
        ++this.sequence;
        return this;
    }

    public SequenceNumber decrement() {
        --this.sequence;
        return this;
    }

    public SequenceNumber getAndIncrement() {
        return new SequenceNumber(this.sequence++);
    }

    public SequenceNumber getAndDecrement() {
        return new SequenceNumber(this.sequence--);
    }

    @Override
    public int intValue() {
        return this.sequence;
    }

    @Override
    public long longValue() {
        return Integer.toUnsignedLong(this.sequence);
    }

    @Override
    public float floatValue() {
        return Float.intBitsToFloat(this.sequence);
    }

    @Override
    public double doubleValue() {
        return Double.longBitsToDouble(this.longValue());
    }

    @Override
    public int compareTo(SequenceNumber other) {
        return Integer.compareUnsigned(this.sequence, other.sequence);
    }

    @Override
    public int compareTo(Number other) {
        return Integer.compareUnsigned(this.sequence, other.intValue());
    }

    @Override
    public int compareTo(int other) {
        return Integer.compareUnsigned(this.sequence, other);
    }

    public boolean equals(Object other) {
        if (other instanceof SequenceNumber) {
            return ((SequenceNumber)other).sequence == this.sequence;
        }
        return false;
    }

    public boolean equals(int other) {
        return Integer.compareUnsigned(this.sequence, other) == 0;
    }

    public int hashCode() {
        return Integer.hashCode(this.sequence);
    }

    public String toString() {
        return Integer.toUnsignedString(this.sequence);
    }
}

