/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types;

public final class UnsignedShort
extends Number
implements Comparable<UnsignedShort> {
    private static final long serialVersionUID = 6006944990203315231L;
    private static final UnsignedShort[] cachedValues = new UnsignedShort[256];
    public static final UnsignedShort MAX_VALUE;
    private final short underlying;

    public UnsignedShort(short underlying) {
        this.underlying = underlying;
    }

    @Override
    public short shortValue() {
        return this.underlying;
    }

    @Override
    public int intValue() {
        return Short.toUnsignedInt(this.underlying);
    }

    @Override
    public long longValue() {
        return Short.toUnsignedLong(this.underlying);
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedShort that = (UnsignedShort)o;
        return this.underlying == that.underlying;
    }

    @Override
    public int compareTo(short value) {
        return Integer.signum(this.intValue() - Short.toUnsignedInt(value));
    }

    @Override
    public int compareTo(UnsignedShort value) {
        return Integer.signum(this.intValue() - value.intValue());
    }

    public static int compare(short left, short right) {
        return Integer.compareUnsigned(Short.toUnsignedInt(left), Short.toUnsignedInt(right));
    }

    public int hashCode() {
        return this.underlying;
    }

    public String toString() {
        return String.valueOf(this.longValue());
    }

    public static UnsignedShort valueOf(short value) {
        if ((value & 0xFF00) == 0) {
            return cachedValues[value];
        }
        return new UnsignedShort(value);
    }

    public static UnsignedShort valueOf(int value) {
        if ((long)value < 0L || (long)value >= 65536L) {
            throw new NumberFormatException("Value \"" + value + "\" lies outside the range [0-65536).");
        }
        return UnsignedShort.valueOf((short)value);
    }

    public static UnsignedShort valueOf(String value) {
        int intVal = Integer.parseInt(value);
        if (intVal < 0 || intVal >= 65536) {
            throw new NumberFormatException("Value \"" + value + "\" lies outside the range [0-65536).");
        }
        return UnsignedShort.valueOf((short)intVal);
    }

    public static int toUnsignedInt(short value) {
        return Short.toUnsignedInt(value);
    }

    public static long toUnsignedLong(short value) {
        return Short.toUnsignedLong(value);
    }

    static {
        for (short i = 0; i < 256; i = (short)(i + 1)) {
            UnsignedShort.cachedValues[i] = new UnsignedShort(i);
        }
        MAX_VALUE = new UnsignedShort(-1);
    }
}

