/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.bval.util.Validate;

public class Reflection {
    private static final Object[][] NATIVE_CODES = new Object[][]{{Byte.TYPE, "byte", "B"}, {Character.TYPE, "char", "C"}, {Double.TYPE, "double", "D"}, {Float.TYPE, "float", "F"}, {Integer.TYPE, "int", "I"}, {Long.TYPE, "long", "J"}, {Short.TYPE, "short", "S"}, {Boolean.TYPE, "boolean", "Z"}, {Void.TYPE, "void", "V"}};
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP;

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = PRIMITIVE_WRAPPER_MAP.get(cls);
        }
        return convertedClass;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        for (Map.Entry<Class<?>, Class<?>> primitiveEntry : PRIMITIVE_WRAPPER_MAP.entrySet()) {
            if (!primitiveEntry.getValue().equals(cls)) continue;
            return primitiveEntry.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getAnnotationValue(Annotation annotation, String name) throws IllegalAccessException, InvocationTargetException {
        Method valueMethod;
        try {
            valueMethod = annotation.annotationType().getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        boolean mustUnset = Reflection.setAccessible(valueMethod, true);
        try {
            Object object = valueMethod.invoke((Object)annotation, new Object[0]);
            return object;
        }
        finally {
            if (mustUnset) {
                Reflection.setAccessible(valueMethod, false);
            }
        }
    }

    public static ClassLoader loaderFromClassOrThread(Class<?> clazz) {
        return Optional.of(clazz).map(Class::getClassLoader).orElseGet(() -> Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader loaderFromThreadOrClass(Class<?> fallbackClass) {
        return Optional.of(Thread.currentThread()).map(Thread::getContextClassLoader).orElseGet(() -> Validate.notNull(fallbackClass).getClassLoader());
    }

    public static Class<?> toClass(String className) throws ClassNotFoundException {
        return Reflection.toClass(className, Reflection.loaderFromClassOrThread(Reflection.class));
    }

    public static Class<?> toClass(String className, ClassLoader loader) throws ClassNotFoundException {
        return Reflection.toClass(className, false, loader);
    }

    public static Class<?> toClass(String className, boolean resolve, ClassLoader loader) throws ClassNotFoundException {
        Validate.notNull(className, "className was null", new Object[0]);
        int dims = 0;
        while (className.endsWith("[]")) {
            ++dims;
            className = className.substring(0, className.length() - 2);
        }
        boolean primitive = false;
        if (className.indexOf(46) == -1) {
            for (int i = 0; !primitive && i < NATIVE_CODES.length; ++i) {
                if (!NATIVE_CODES[i][1].equals(className)) continue;
                if (dims == 0) {
                    return (Class)NATIVE_CODES[i][0];
                }
                className = (String)NATIVE_CODES[i][2];
                primitive = true;
            }
        }
        if (dims > 0) {
            StringBuilder buf = new StringBuilder(className.length() + dims + 2);
            for (int i = 0; i < dims; ++i) {
                buf.append('[');
            }
            if (!primitive) {
                buf.append('L');
            }
            buf.append(className);
            if (!primitive) {
                buf.append(';');
            }
            className = buf.toString();
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return Class.forName(className, resolve, loader);
    }

    public static String getProperty(String name) {
        return System.getProperty(name);
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        return clazz.getDeclaredFields();
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz, Class<?> ... parameters) {
        try {
            return clazz.getDeclaredConstructor(parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameters) {
        try {
            return clazz.getDeclaredMethod(name, parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return clazz.getDeclaredMethods();
    }

    public static <T> Constructor<? extends T>[] getDeclaredConstructors(Class<T> clazz) {
        return clazz.getDeclaredConstructors();
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <T> T find(Class<?> clazz, Function<Class<?>, T> search) {
        for (Class<?> t : Reflection.hierarchy(clazz, Interfaces.INCLUDE)) {
            T value = search.apply(t);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static <T> T newInstance(Class<T> cls) {
        try {
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot instantiate : " + cls, ex);
        }
    }

    public static boolean setAccessible(AccessibleObject o, boolean accessible) {
        if (o == null || o.isAccessible() == accessible) {
            return false;
        }
        if (!accessible && System.getSecurityManager() == null) {
            return false;
        }
        Member m = (Member)((Object)o);
        if (Modifier.isPublic(m.getModifiers()) && Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
            return false;
        }
        o.setAccessible(accessible);
        return true;
    }

    public static Iterable<Class<?>> hierarchy(Class<?> type, Interfaces interfacesBehavior) {
        if (type == null) {
            return Collections.emptySet();
        }
        ClassHierarchy classes = new ClassHierarchy(type);
        return interfacesBehavior == Interfaces.INCLUDE ? new FullHierarchy(classes) : classes;
    }

    static {
        HashMap<Class<Object>, Class<Void>> m = new HashMap<Class<Object>, Class<Void>>();
        m.put(Boolean.TYPE, Boolean.class);
        m.put(Byte.TYPE, Byte.class);
        m.put(Character.TYPE, Character.class);
        m.put(Short.TYPE, Short.class);
        m.put(Integer.TYPE, Integer.class);
        m.put(Long.TYPE, Long.class);
        m.put(Double.TYPE, Double.class);
        m.put(Float.TYPE, Float.class);
        m.put(Void.TYPE, Void.TYPE);
        PRIMITIVE_WRAPPER_MAP = Collections.unmodifiableMap(m);
    }

    public static enum Interfaces {
        INCLUDE,
        EXCLUDE;

    }

    public static final class FullHierarchy
    implements Iterable<Class<?>> {
        private final Iterable<Class<?>> classes;

        public FullHierarchy(Iterable<Class<?>> classes) {
            this.classes = classes;
        }

        @Override
        public Iterator<Class<?>> iterator() {
            final HashSet seenInterfaces = new HashSet();
            final Iterator<Class<?>> wrapped = this.classes.iterator();
            return new Iterator<Class<?>>(){
                Iterator<Class<?>> interfaces = Collections.emptyIterator();

                @Override
                public boolean hasNext() {
                    return this.interfaces.hasNext() || wrapped.hasNext();
                }

                @Override
                public Class<?> next() {
                    if (this.interfaces.hasNext()) {
                        Class<?> nextInterface = this.interfaces.next();
                        seenInterfaces.add(nextInterface);
                        return nextInterface;
                    }
                    Class nextSuperclass = (Class)wrapped.next();
                    LinkedHashSet currentInterfaces = new LinkedHashSet();
                    this.walkInterfaces(currentInterfaces, nextSuperclass);
                    this.interfaces = currentInterfaces.iterator();
                    return nextSuperclass;
                }

                private void walkInterfaces(Set<Class<?>> addTo, Class<?> c) {
                    for (Class<?> iface : c.getInterfaces()) {
                        if (!seenInterfaces.contains(iface)) {
                            addTo.add(iface);
                        }
                        this.walkInterfaces(addTo, iface);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static final class ClassHierarchy
    implements Iterable<Class<?>> {
        private final Class<?> type;

        public ClassHierarchy(Class<?> type) {
            this.type = type;
        }

        @Override
        public Iterator<Class<?>> iterator() {
            return new Iterator<Class<?>>(){
                Optional<Class<?>> next;
                {
                    this.next = Optional.of(type);
                }

                @Override
                public boolean hasNext() {
                    return this.next.isPresent();
                }

                @Override
                public Class<?> next() {
                    Class<?> result = this.next.orElseThrow(NoSuchElementException::new);
                    this.next = Optional.ofNullable(result.getSuperclass());
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

