/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.queue.AuditQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AuditBatchQueue
extends AuditQueue
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AuditBatchQueue.class);
    private BlockingQueue<AuditEventBase> queue = null;
    private Collection<AuditEventBase> localBatchBuffer = new ArrayList<AuditEventBase>();
    Thread consumerThread = null;
    static int threadCount = 0;
    static final String DEFAULT_NAME = "batch";

    public AuditBatchQueue(AuditHandler consumer) {
        super(consumer);
        this.setName(DEFAULT_NAME);
    }

    @Override
    public boolean log(AuditEventBase event) {
        try {
            this.queue.put(event);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        AuditEventBase event;
        boolean ret = true;
        Iterator<AuditEventBase> iterator = events.iterator();
        while (iterator.hasNext() && (ret = this.log(event = iterator.next()))) {
        }
        return ret;
    }

    @Override
    public void init(Properties prop, String basePropertyName) {
        String propPrefix = "xasecure.audit.batch";
        if (basePropertyName != null) {
            propPrefix = basePropertyName;
        }
        super.init(prop, propPrefix);
    }

    @Override
    public synchronized void start() {
        if (this.consumerThread != null) {
            logger.error("Provider is already started. name=" + this.getName());
            return;
        }
        logger.info("Creating ArrayBlockingQueue with maxSize=" + this.getMaxQueueSize());
        this.queue = new ArrayBlockingQueue<AuditEventBase>(this.getMaxQueueSize());
        this.consumer.start();
        if (this.fileSpoolerEnabled) {
            this.fileSpooler.start();
        }
        this.consumerThread = new Thread((Runnable)this, this.getClass().getName() + threadCount++);
        this.consumerThread.setDaemon(true);
        this.consumerThread.start();
    }

    @Override
    public void stop() {
        logger.info("Stop called. name=" + this.getName());
        this.setDrain(true);
        this.flush();
        try {
            if (this.consumerThread != null) {
                logger.info("Interrupting consumerThread. name=" + this.getName() + ", consumer=" + (this.consumer == null ? null : this.consumer.getName()));
                this.consumerThread.interrupt();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.consumerThread = null;
    }

    @Override
    public void waitToComplete() {
        int defaultTimeOut = -1;
        this.waitToComplete(defaultTimeOut);
        this.consumer.waitToComplete(defaultTimeOut);
    }

    @Override
    public void waitToComplete(long timeout) {
        this.setDrain(true);
        this.flush();
        long sleepTime = 1000L;
        long startTime = System.currentTimeMillis();
        int prevQueueSize = -1;
        int staticLoopCount = 0;
        while (this.queue.size() > 0 || this.localBatchBuffer.size() > 0) {
            if (prevQueueSize == this.queue.size()) {
                logger.error("Queue size is not changing. " + this.getName() + ".size=" + this.queue.size());
                if (++staticLoopCount > 5) {
                    logger.error("Aborting writing to consumer. Some logs will be discarded." + this.getName() + ".size=" + this.queue.size());
                    break;
                }
            } else {
                staticLoopCount = 0;
                prevQueueSize = this.queue.size();
            }
            if (this.consumerThread != null) {
                this.consumerThread.interrupt();
            }
            try {
                Thread.sleep(sleepTime);
                if (timeout <= 0L || System.currentTimeMillis() - startTime <= timeout) continue;
                break;
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        this.consumer.waitToComplete(timeout);
    }

    @Override
    public void flush() {
        if (this.fileSpoolerEnabled) {
            this.fileSpooler.flush();
        }
        this.consumer.flush();
    }

    @Override
    public void run() {
        try {
            MDC.clear();
            this.runLogAudit();
        }
        catch (Throwable t) {
            logger.error("Exited thread abnormaly. queue=" + this.getName(), t);
        }
    }

    public void runLogAudit() {
        long lastDispatchTime = System.currentTimeMillis();
        boolean isDestActive = true;
        while (true) {
            this.logStatusIfRequired();
            long nextDispatchDuration = lastDispatchTime - System.currentTimeMillis() + (long)this.getMaxBatchInterval();
            boolean isToSpool = false;
            boolean fileSpoolDrain = false;
            try {
                if (this.fileSpoolerEnabled && this.fileSpooler.isPending()) {
                    int percentUsed = this.queue.size() * 100 / this.getMaxQueueSize();
                    long lastAttemptDelta = this.fileSpooler.getLastAttemptTimeDelta();
                    boolean bl = fileSpoolDrain = lastAttemptDelta > (long)this.fileSpoolMaxWaitTime;
                    if (!this.isDrain() && !fileSpoolDrain && percentUsed < this.fileSpoolDrainThresholdPercent) {
                        if (nextDispatchDuration > 0L) {
                            Thread.sleep(nextDispatchDuration);
                        }
                        lastDispatchTime = System.currentTimeMillis();
                        continue;
                    }
                    isToSpool = true;
                }
                AuditEventBase event = null;
                event = !isToSpool && !this.isDrain() && !fileSpoolDrain && nextDispatchDuration > 0L ? this.queue.poll(nextDispatchDuration, TimeUnit.MILLISECONDS) : (AuditEventBase)this.queue.poll();
                if (event != null) {
                    this.localBatchBuffer.add(event);
                    if (this.getMaxBatchSize() >= this.localBatchBuffer.size()) {
                        this.queue.drainTo(this.localBatchBuffer, this.getMaxBatchSize() - this.localBatchBuffer.size());
                    }
                } else {
                    nextDispatchDuration = lastDispatchTime - System.currentTimeMillis() + (long)this.getMaxBatchInterval();
                    lastDispatchTime = System.currentTimeMillis();
                }
            }
            catch (InterruptedException e) {
                logger.info("Caught exception in consumer thread. Shutdown might be in progress");
                this.setDrain(true);
            }
            catch (Throwable t) {
                logger.error("Caught error during processing request.", t);
            }
            this.addTotalCount(this.localBatchBuffer.size());
            if (this.localBatchBuffer.size() > 0 && isToSpool) {
                if (isDestActive) {
                    logger.info("Switching to file spool. Queue = {}, dest = {}", (Object)this.getName(), (Object)this.consumer.getName());
                }
                isDestActive = false;
                lastDispatchTime = System.currentTimeMillis();
                this.fileSpooler.stashLogs(this.localBatchBuffer);
                this.addStashedCount(this.localBatchBuffer.size());
                this.localBatchBuffer.clear();
            } else if (this.localBatchBuffer.size() > 0 && (this.isDrain() || this.localBatchBuffer.size() >= this.getMaxBatchSize() || nextDispatchDuration <= 0L)) {
                if (this.fileSpoolerEnabled && !isDestActive) {
                    logger.info("Switching to writing to the destination. Queue = {}, dest = {}", (Object)this.getName(), (Object)this.consumer.getName());
                }
                lastDispatchTime = System.currentTimeMillis();
                boolean ret = this.consumer.log(this.localBatchBuffer);
                if (!ret) {
                    if (this.fileSpoolerEnabled) {
                        logger.info("Switching to file spool. Queue = {}, dest = {}", (Object)this.getName(), (Object)this.consumer.getName());
                        this.fileSpooler.stashLogs(this.localBatchBuffer);
                        isDestActive = false;
                        this.addStashedCount(this.localBatchBuffer.size());
                    } else {
                        this.addFailedCount(this.localBatchBuffer.size());
                        this.logFailedEvent(this.localBatchBuffer);
                    }
                } else {
                    isDestActive = true;
                    this.addSuccessCount(this.localBatchBuffer.size());
                }
                this.localBatchBuffer.clear();
            }
            if (!this.isDrain()) continue;
            if (this.queue.isEmpty() && this.localBatchBuffer.size() <= 0) break;
            logger.info("Queue is not empty. Will retry. queue.size = {}, localBatchBuffer.size = {}", (Object)this.queue.size(), (Object)this.localBatchBuffer.size());
            if (!this.isDrainMaxTimeElapsed()) continue;
            logger.warn("Exiting polling loop because max time allowed reached. name=" + this.getName() + ", waited for " + (this.stopTime - System.currentTimeMillis()) + " ms");
        }
        logger.info("Exiting consumerThread. Queue = {}, dest = {}", (Object)this.getName(), (Object)this.consumer.getName());
        try {
            logger.info("Calling to stop consumer. name = {}, consumer.name = {}", (Object)this.getName(), (Object)this.consumer.getName());
            this.consumer.stop();
            if (this.fileSpoolerEnabled) {
                this.fileSpooler.stop();
            }
        }
        catch (Throwable t) {
            logger.error("Error while calling stop on consumer.", t);
        }
        this.logStatus();
        logger.info("Exiting consumerThread.run() method. name=" + this.getName());
    }
}

