/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.HashSet;
import java.util.Set;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAnyOfExpectedTagsPresentConditionEvaluator
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAnyOfExpectedTagsPresentConditionEvaluator.class);
    private final Set<String> policyConditionTags = new HashSet<String>();

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAnyOfExpectedTagsPresentConditionEvaluator.init(" + this.condition + ")");
        }
        super.init();
        if (this.condition != null) {
            for (String value : this.condition.getValues()) {
                this.policyConditionTags.add(value.trim());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAnyOfExpectedTagsPresentConditionEvaluator.init(" + this.condition + "): Tags[" + this.policyConditionTags + "]");
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAnyOfExpectedTagsPresentConditionEvaluator.isMatched(" + request + ")");
        }
        boolean matched = false;
        Set<RangerTagForEval> resourceTags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
        if (resourceTags != null) {
            for (RangerTagForEval tag : resourceTags) {
                if (!this.policyConditionTags.contains(tag.getType())) continue;
                matched = true;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAnyOfExpectedTagsPresentConditionEvaluator.isMatched(" + request + "): " + matched);
        }
        return matched;
    }
}

