/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.RangerKMSMKI;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerHSM
implements RangerKMSMKI {
    static final Logger logger = LoggerFactory.getLogger(RangerHSM.class);
    private String passwd = null;
    private String alias = "RangerKMSKey";
    private String partitionName = null;
    private KeyStore myStore = null;
    private String hsm_keystore = null;
    private static final String MK_CIPHER = "AES";
    private static final int MK_KeySize = 128;
    private static final String PARTITION_PASSWORD = "ranger.ks.hsm.partition.password";
    private static final String PARTITION_NAME = "ranger.ks.hsm.partition.name";
    private static final String HSM_TYPE = "ranger.ks.hsm.type";

    public RangerHSM() {
    }

    public RangerHSM(Configuration conf) {
        logger.info("RangerHSM provider");
        this.passwd = conf.get(PARTITION_PASSWORD);
        this.partitionName = conf.get(PARTITION_NAME);
        this.hsm_keystore = conf.get(HSM_TYPE);
        String errorMsg = "";
        try {
            ByteArrayInputStream is1 = new ByteArrayInputStream(("tokenlabel:" + this.partitionName).getBytes());
            logger.debug("Loading HSM : Tokenlabel - '{}', Type - '{}' ", (Object)this.partitionName, (Object)this.hsm_keystore);
            this.myStore = KeyStore.getInstance("Luna");
            if (this.myStore == null) {
                logger.error("Luna not found. Please verify the Ranger KMS HSM configuration setup.");
            } else {
                this.myStore.load(is1, this.passwd.toCharArray());
            }
        }
        catch (KeyStoreException kse) {
            errorMsg = "Unable to create keystore object : " + kse.getMessage();
        }
        catch (NoSuchAlgorithmException nsae) {
            errorMsg = "Unexpected NoSuchAlgorithmException while loading keystore : " + nsae.getMessage();
        }
        catch (CertificateException e) {
            errorMsg = "Unexpected CertificateException while loading keystore : " + e.getMessage();
        }
        catch (IOException e) {
            errorMsg = "Unexpected IOException while loading keystore : " + e.getMessage();
        }
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            throw new RuntimeCryptoException(errorMsg);
        }
    }

    @Override
    public boolean generateMasterKey(String password) throws Throwable {
        logger.debug("==> RangerHSM.generateMasterKey()");
        if (!this.myStore.containsAlias(this.alias)) {
            KeyGenerator keyGen = null;
            SecretKey aesKey = null;
            try {
                logger.info("Generating AES Master Key for '{}' HSM Provider", (Object)this.hsm_keystore);
                keyGen = KeyGenerator.getInstance(MK_CIPHER, this.hsm_keystore);
                keyGen.init(128);
                aesKey = keyGen.generateKey();
                this.myStore.setKeyEntry(this.alias, aesKey, password.toCharArray(), null);
                return true;
            }
            catch (Exception e) {
                logger.error("generateMasterKey : Exception during Ranger Master Key Generation - {}", (Object)e.getMessage());
            }
        } else {
            logger.info("Master key with alias - '{}' already exists!", (Object)this.alias);
        }
        logger.debug("<== RangerHSM.generateMasterKey()");
        return false;
    }

    @Override
    public String getMasterKey(String password) throws Throwable {
        logger.debug("==> RangerHSM.getMasterKey()");
        if (this.myStore != null) {
            try {
                logger.debug("Searching for Ranger Master Key in Luna Keystore");
                boolean result = this.myStore.containsAlias(this.alias);
                if (result) {
                    logger.debug("Ranger Master Key is present in Keystore");
                    SecretKey key = (SecretKey)this.myStore.getKey(this.alias, password.toCharArray());
                    return Base64.encode(key.getEncoded());
                }
            }
            catch (Exception e) {
                logger.error("getMasterKey : Exception searching for Ranger Master Key - {} ", (Object)e.getMessage());
            }
        }
        logger.debug("<== RangerHSM.getMasterKey()");
        return null;
    }

    public boolean setMasterKey(String password, byte[] key) {
        if (this.myStore != null) {
            try {
                SecretKeySpec aesKey = new SecretKeySpec(key, MK_CIPHER);
                this.myStore.setKeyEntry(this.alias, aesKey, password.toCharArray(), null);
                return true;
            }
            catch (KeyStoreException e) {
                logger.error("setMasterKey : Exception while setting Master Key, Error - {} ", (Object)e.getMessage());
            }
        }
        return false;
    }
}

