/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.solr.authorizer;

import java.io.IOException;
import java.util.Map;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.AuthorizationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSolrAuthorizer
extends SearchComponent
implements AuthorizationPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RangerSolrAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "solr";
    private static final String RANGER_SOLR_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.solr.authorizer.RangerSolrAuthorizer";
    private AuthorizationPlugin rangerSolrAuthorizerImpl = null;
    private SearchComponent rangerSearchComponentImpl = null;
    private RangerPluginClassLoader rangerPluginClassLoader = null;

    public RangerSolrAuthorizer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerSolrAuthorizer.RangerSolrAuthorizer()");
        }
        this.init0();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerSolrAuthorizer.RangerSolrAuthorizer()");
        }
    }

    private void init0() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerSolrAuthorizer.init0()");
        }
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, ((Object)((Object)this)).getClass());
            Class<?> cls = Class.forName(RANGER_SOLR_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            Object impl = cls.newInstance();
            this.rangerSolrAuthorizerImpl = (AuthorizationPlugin)impl;
            this.rangerSearchComponentImpl = (SearchComponent)impl;
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerSolrPlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerSolrAuthorizer.init0()");
        }
    }

    public void init(Map<String, Object> initInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerSolrAuthorizer.init(Resource)");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerSolrAuthorizerImpl.init(initInfo);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerSolrAuthorizer.init(Resource)");
        }
    }

    public void init(NamedList args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerSolrAuthorizer.init(" + args.toString() + ")");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerSearchComponentImpl.init(args);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerSolrAuthorizer.init(" + args.toString() + ")");
        }
    }

    public void close() throws IOException {
        boolean isAuthorizer;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerSolrAuthorizer.close(Resource)");
        }
        if (isAuthorizer = StringUtils.equals((String)super.getName(), (String)RANGER_SOLR_AUTHORIZER_IMPL_CLASSNAME)) {
            try {
                this.activatePluginClassLoader();
                this.rangerSolrAuthorizerImpl.close();
            }
            finally {
                this.deactivatePluginClassLoader();
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("RangerSolrAuthorizer.close(): not forwarding for instance '" + super.getName() + "'");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerSolrAuthorizer.close()");
        }
    }

    public AuthorizationResponse authorize(AuthorizationContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerSolrAuthorizer.authorize(context)");
        }
        AuthorizationResponse ret = null;
        try {
            this.activatePluginClassLoader();
            ret = this.rangerSolrAuthorizerImpl.authorize(context);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerSolrAuthorizer.authorize(context)");
        }
        return ret;
    }

    public void prepare(ResponseBuilder responseBuilder) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerSolrAuthorizer.prepare()");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerSearchComponentImpl.prepare(responseBuilder);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerSolrAuthorizer.prepare()");
        }
    }

    public void process(ResponseBuilder responseBuilder) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerSolrAuthorizer.process()");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerSearchComponentImpl.process(responseBuilder);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerSolrAuthorizer.process()");
        }
    }

    public String getDescription() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerSolrAuthorizer.getDescription()");
        }
        String ret = null;
        try {
            this.activatePluginClassLoader();
            ret = this.rangerSearchComponentImpl.getDescription();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerSolrAuthorizer.getDescription()");
        }
        return ret;
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

