/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.process;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.ugsyncutil.model.FileSyncSourceInfo;
import org.apache.ranger.ugsyncutil.model.UgsyncAuditInfo;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.usergroupsync.AbstractUserGroupSource;
import org.apache.ranger.usergroupsync.UserGroupSink;
import org.apache.ranger.usergroupsync.UserGroupSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSourceUserGroupBuilder
extends AbstractUserGroupSource
implements UserGroupSource {
    private static final Logger LOG = LoggerFactory.getLogger(FileSourceUserGroupBuilder.class);
    private Map<String, List<String>> user2GroupListMap = new HashMap<String, List<String>>();
    private String userGroupFilename = null;
    private Map<String, Map<String, String>> sourceUsers;
    private Map<String, Map<String, String>> sourceGroups;
    private Map<String, Set<String>> sourceGroupUsers;
    private long usergroupFileModified = 0L;
    private UgsyncAuditInfo ugsyncAuditInfo;
    private FileSyncSourceInfo fileSyncSourceInfo;
    private boolean isStartupFlag = false;
    private boolean isUpdateSinkSucc = true;
    private int deleteCycles;
    private boolean computeDeletes = false;
    private String currentSyncSource;

    public static void main(String[] args) throws Throwable {
        FileSourceUserGroupBuilder filesourceUGBuilder = new FileSourceUserGroupBuilder();
        if (args.length > 0) {
            filesourceUGBuilder.setUserGroupFilename(args[0]);
        }
        filesourceUGBuilder.init();
        UserGroupSink ugSink = UserGroupSyncConfig.getInstance().getUserGroupSink();
        LOG.info("initializing sink: " + ugSink.getClass().getName());
        ugSink.init();
        filesourceUGBuilder.updateSink(ugSink);
        if (LOG.isDebugEnabled()) {
            filesourceUGBuilder.print();
        }
    }

    @Override
    public void init() throws Throwable {
        this.isStartupFlag = true;
        this.deleteCycles = 1;
        this.currentSyncSource = this.config.getCurrentSyncSource();
        if (this.userGroupFilename == null) {
            this.userGroupFilename = this.config.getUserSyncFileSource();
        }
        this.ugsyncAuditInfo = new UgsyncAuditInfo();
        this.fileSyncSourceInfo = new FileSyncSourceInfo();
        this.ugsyncAuditInfo.setSyncSource(this.currentSyncSource);
        this.ugsyncAuditInfo.setFileSyncSourceInfo(this.fileSyncSourceInfo);
        this.fileSyncSourceInfo.setFileName(this.userGroupFilename);
        this.buildUserGroupInfo();
    }

    @Override
    public boolean isChanged() {
        long TempUserGroupFileModifedAt;
        this.computeDeletes = false;
        if (!this.isUpdateSinkSucc) {
            LOG.info("Previous updateSink failed and hence retry!!");
            this.isUpdateSinkSucc = true;
            return true;
        }
        try {
            if (this.config.isUserSyncDeletesEnabled() && (long)this.deleteCycles >= this.config.getUserSyncDeletesFrequency()) {
                this.deleteCycles = 1;
                this.computeDeletes = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Compute deleted users/groups is enabled for this sync cycle");
                }
                return true;
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to get information about usersync delete frequency", t);
        }
        if (this.config.isUserSyncDeletesEnabled()) {
            ++this.deleteCycles;
        }
        return this.usergroupFileModified != (TempUserGroupFileModifedAt = new File(this.userGroupFilename).lastModified());
    }

    @Override
    public void updateSink(UserGroupSink sink) throws Throwable {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date lastModifiedTime = new Date(this.usergroupFileModified);
        Date syncTime = new Date(System.currentTimeMillis());
        this.fileSyncSourceInfo.setLastModified(formatter.format(lastModifiedTime));
        this.fileSyncSourceInfo.setSyncTime(formatter.format(syncTime));
        if (this.isChanged() || this.isStartupFlag) {
            this.buildUserGroupInfo();
            for (Map.Entry<String, List<String>> entry : this.user2GroupListMap.entrySet()) {
                String userName = entry.getKey();
                HashMap<String, String> userAttrMap = new HashMap<String, String>();
                userAttrMap.put("original_name", userName);
                userAttrMap.put("full_name", userName);
                userAttrMap.put("sync_source", this.currentSyncSource);
                this.sourceUsers.put(userName, userAttrMap);
                List<String> groups = entry.getValue();
                if (groups == null) continue;
                for (String groupName : groups) {
                    HashMap<String, String> groupAttrMap = new HashMap<String, String>();
                    groupAttrMap.put("original_name", groupName);
                    groupAttrMap.put("full_name", groupName);
                    groupAttrMap.put("sync_source", this.currentSyncSource);
                    this.sourceGroups.put(groupName, groupAttrMap);
                    Set<String> groupUsers = this.sourceGroupUsers.get(groupName);
                    if (CollectionUtils.isNotEmpty(groupUsers)) {
                        groupUsers.add(userName);
                    } else {
                        groupUsers = new HashSet<String>();
                        groupUsers.add(userName);
                    }
                    this.sourceGroupUsers.put(groupName, groupUsers);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Users = " + this.sourceUsers.keySet());
                LOG.debug("Groups = " + this.sourceGroups.keySet());
                LOG.debug("GroupUsers = " + this.sourceGroupUsers.keySet());
            }
            try {
                sink.addOrUpdateUsersGroups(this.sourceGroups, this.sourceUsers, this.sourceGroupUsers, this.computeDeletes);
            }
            catch (Throwable t) {
                LOG.error("Failed to update ranger admin. Will retry in next sync cycle!!", t);
                this.isUpdateSinkSucc = false;
            }
        }
        try {
            sink.postUserGroupAuditInfo(this.ugsyncAuditInfo);
        }
        catch (Throwable t) {
            LOG.error("sink.postUserGroupAuditInfo failed with exception: " + t.getMessage());
        }
        this.isStartupFlag = false;
    }

    private void setUserGroupFilename(String filename) {
        this.userGroupFilename = filename;
    }

    private void print() {
        for (String user : this.user2GroupListMap.keySet()) {
            LOG.debug("USER:" + user);
            List<String> groups = this.user2GroupListMap.get(user);
            if (groups == null) continue;
            for (String group : groups) {
                LOG.debug("\tGROUP: " + group);
            }
        }
    }

    public void buildUserGroupInfo() throws Throwable {
        this.sourceUsers = new HashMap<String, Map<String, String>>();
        this.sourceGroups = new HashMap<String, Map<String, String>>();
        this.sourceGroupUsers = new HashMap<String, Set<String>>();
        this.buildUserGroupList();
        if (LOG.isDebugEnabled()) {
            this.print();
        }
    }

    public void buildUserGroupList() throws Throwable {
        if (this.userGroupFilename == null) {
            throw new Exception("User Group Source File is not Configured. Please maintain in unixauthservice.properties or pass it as command line argument for org.apache.ranger.unixusersync.process.FileSourceUserGroupBuilder");
        }
        File f = new File(this.userGroupFilename);
        if (f.exists() && f.canRead()) {
            Map<String, List<String>> tmpUser2GroupListMap = null;
            tmpUser2GroupListMap = this.isJsonFile(this.userGroupFilename) ? this.readJSONfile(f) : this.readTextFile(f);
            if (tmpUser2GroupListMap != null) {
                this.user2GroupListMap = tmpUser2GroupListMap;
                this.usergroupFileModified = f.lastModified();
            } else {
                LOG.info("No new UserGroup to sync at this time");
            }
        } else {
            throw new Exception("User Group Source File " + this.userGroupFilename + "doesn't not exist or readable");
        }
    }

    public boolean isJsonFile(String userGroupFilename) {
        boolean ret = false;
        if (userGroupFilename.toLowerCase().endsWith(".json")) {
            ret = true;
        }
        return ret;
    }

    public Map<String, List<String>> readJSONfile(File jsonFile) throws Exception {
        return (Map)JsonUtils.getMapper().readValue(jsonFile, (TypeReference)new TypeReference<HashMap<String, List<String>>>(){});
    }

    public Map<String, List<String>> readTextFile(File textFile) throws Exception {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        String delimiter = this.config.getUserSyncFileSourceDelimiter();
        CSVFormat csvFormat = CSVFormat.newFormat((char)delimiter.charAt(0));
        try (CSVParser csvParser = new CSVParser((Reader)new BufferedReader(new FileReader(textFile)), csvFormat);){
            List csvRecordList = csvParser.getRecords();
            if (csvRecordList != null) {
                for (CSVRecord csvRecord : csvRecordList) {
                    ArrayList<String> groups = new ArrayList<String>();
                    String user = csvRecord.get(0);
                    user = user.replaceAll("^\"|\"$", "");
                    int i = csvRecord.size();
                    for (int j = 1; j < i; ++j) {
                        String group = csvRecord.get(j);
                        if (group == null || group.isEmpty()) continue;
                        group = group.replaceAll("^\"|\"$", "");
                        groups.add(group);
                    }
                    ret.put(user, groups);
                }
            }
        }
        return ret;
    }
}

