/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;

public final class ServerImplUtils {
    private ServerImplUtils() {
    }

    public static RaftServerProxy newRaftServer(RaftPeerId id, RaftGroup group, RaftStorage.StartupOption option, StateMachine.Registry stateMachineRegistry, ThreadGroup threadGroup, RaftProperties properties, Parameters parameters) throws IOException {
        RaftServer.LOG.debug("newRaftServer: {}, {}", (Object)id, (Object)group);
        if (group != null && !group.getPeers().isEmpty()) {
            Preconditions.assertNotNull(id, "RaftPeerId %s is not in RaftGroup %s", id, group);
            Preconditions.assertNotNull(group.getPeer(id), "RaftPeerId %s is not in RaftGroup %s", id, group);
        }
        RaftServerProxy proxy = ServerImplUtils.newRaftServer(id, stateMachineRegistry, threadGroup, properties, parameters);
        proxy.initGroups(group, option);
        return proxy;
    }

    private static RaftServerProxy newRaftServer(RaftPeerId id, StateMachine.Registry stateMachineRegistry, ThreadGroup threadGroup, RaftProperties properties, Parameters parameters) throws IOException {
        RaftServerProxy proxy;
        TimeDuration sleepTime = TimeDuration.valueOf(500L, TimeUnit.MILLISECONDS);
        try {
            proxy = JavaUtils.attemptRepeatedly(() -> new RaftServerProxy(id, stateMachineRegistry, properties, parameters, threadGroup), 5, sleepTime, "new RaftServerProxy", RaftServer.LOG);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException("Interrupted when creating RaftServer " + id, e);
        }
        return proxy;
    }

    public static RaftConfiguration newRaftConfiguration(List<RaftPeer> conf, List<RaftPeer> listener, long index, List<RaftPeer> oldConf, List<RaftPeer> oldListener) {
        RaftConfigurationImpl.Builder b = RaftConfigurationImpl.newBuilder().setConf(conf, listener).setLogEntryIndex(index);
        if (!oldConf.isEmpty() || !oldListener.isEmpty()) {
            b.setOldConf(oldConf, oldListener);
        }
        return b.build();
    }

    static long effectiveCommitIndex(long leaderCommitIndex, TermIndex followerPrevious, int numAppendEntries) {
        long previous = followerPrevious != null ? followerPrevious.getIndex() : 0L;
        return Math.min(leaderCommitIndex, previous + (long)numAppendEntries);
    }

    static void assertGroup(RaftGroupMemberId serverMemberId, RaftClientRequest request) throws GroupMismatchException {
        ServerImplUtils.assertGroup(serverMemberId, request.getRequestorId(), request.getRaftGroupId());
    }

    static void assertGroup(RaftGroupMemberId localMemberId, Object remoteId, RaftGroupId remoteGroupId) throws GroupMismatchException {
        RaftGroupId localGroupId = localMemberId.getGroupId();
        if (!localGroupId.equals(remoteGroupId)) {
            throw new GroupMismatchException(localMemberId + ": The group (" + remoteGroupId + ") of remote " + remoteId + " does not match the group (" + localGroupId + ") of local " + localMemberId.getPeerId());
        }
    }

    static void assertEntries(RaftProtos.AppendEntriesRequestProto proto, TermIndex previous, ServerState state) {
        List<RaftProtos.LogEntryProto> entries = proto.getEntriesList();
        if (entries != null && !entries.isEmpty()) {
            long index0 = entries.get(0).getIndex();
            if (index0 != state.getSnapshotIndex() + 1L) {
                long expected = previous == null || previous.getTerm() == 0L ? 0L : previous.getIndex() + 1L;
                Preconditions.assertTrue(index0 == expected, "Unexpected Index: previous is %s but entries[%s].getIndex() == %s != %s", previous, 0, index0, expected);
            }
            long leaderTerm = proto.getLeaderTerm();
            for (int i = 0; i < entries.size(); ++i) {
                RaftProtos.LogEntryProto entry = entries.get(i);
                long entryTerm = entry.getTerm();
                Preconditions.assertTrue(entryTerm <= leaderTerm, "Unexpected Term: entries[%s].getTerm() == %s > leaderTerm == %s", i, entryTerm, leaderTerm);
                long indexI = entry.getIndex();
                long expected = index0 + (long)i;
                Preconditions.assertTrue(indexI == expected, "Unexpected Index: entries[0].getIndex() == %s but entries[%s].getIndex() == %s != %s", index0, i, indexI, expected);
            }
        }
    }
}

