/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.protocol.header;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import org.apache.rocketmq.common.protocol.header.SendMessageRequestHeaderV2;
import org.apache.rocketmq.common.rpc.TopicQueueRequestHeader;
import org.apache.rocketmq.remoting.annotation.CFNotNull;
import org.apache.rocketmq.remoting.annotation.CFNullable;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class SendMessageRequestHeader
extends TopicQueueRequestHeader {
    @CFNotNull
    private String producerGroup;
    @CFNotNull
    private String topic;
    @CFNotNull
    private String defaultTopic;
    @CFNotNull
    private Integer defaultTopicQueueNums;
    @CFNotNull
    private Integer queueId;
    @CFNotNull
    private Integer sysFlag;
    @CFNotNull
    private Long bornTimestamp;
    @CFNotNull
    private Integer flag;
    @CFNullable
    private String properties;
    @CFNullable
    private Integer reconsumeTimes;
    @CFNullable
    private boolean unitMode = false;
    @CFNullable
    private boolean batch = false;
    private Integer maxReconsumeTimes;

    public void checkFields() throws RemotingCommandException {
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getDefaultTopic() {
        return this.defaultTopic;
    }

    public void setDefaultTopic(String defaultTopic) {
        this.defaultTopic = defaultTopic;
    }

    public Integer getDefaultTopicQueueNums() {
        return this.defaultTopicQueueNums;
    }

    public void setDefaultTopicQueueNums(Integer defaultTopicQueueNums) {
        this.defaultTopicQueueNums = defaultTopicQueueNums;
    }

    @Override
    public Integer getQueueId() {
        return this.queueId;
    }

    @Override
    public void setQueueId(Integer queueId) {
        this.queueId = queueId;
    }

    public Integer getSysFlag() {
        return this.sysFlag;
    }

    public void setSysFlag(Integer sysFlag) {
        this.sysFlag = sysFlag;
    }

    public Long getBornTimestamp() {
        return this.bornTimestamp;
    }

    public void setBornTimestamp(Long bornTimestamp) {
        this.bornTimestamp = bornTimestamp;
    }

    public Integer getFlag() {
        return this.flag;
    }

    public void setFlag(Integer flag) {
        this.flag = flag;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public Integer getReconsumeTimes() {
        return this.reconsumeTimes;
    }

    public void setReconsumeTimes(Integer reconsumeTimes) {
        this.reconsumeTimes = reconsumeTimes;
    }

    public boolean isUnitMode() {
        return this.unitMode;
    }

    public void setUnitMode(boolean isUnitMode) {
        this.unitMode = isUnitMode;
    }

    public Integer getMaxReconsumeTimes() {
        return this.maxReconsumeTimes;
    }

    public void setMaxReconsumeTimes(Integer maxReconsumeTimes) {
        this.maxReconsumeTimes = maxReconsumeTimes;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }

    public static SendMessageRequestHeader parseRequestHeader(RemotingCommand request) throws RemotingCommandException {
        SendMessageRequestHeaderV2 requestHeaderV2 = null;
        SendMessageRequestHeader requestHeader = null;
        switch (request.getCode()) {
            case 310: 
            case 320: {
                requestHeaderV2 = (SendMessageRequestHeaderV2)request.decodeCommandCustomHeader(SendMessageRequestHeaderV2.class);
            }
            case 10: {
                requestHeader = null == requestHeaderV2 ? (SendMessageRequestHeader)request.decodeCommandCustomHeader(SendMessageRequestHeader.class) : SendMessageRequestHeaderV2.createSendMessageRequestHeaderV1(requestHeaderV2);
            }
        }
        return requestHeader;
    }

    public static SendMessageRequestHeaderV2 decodeSendMessageHeaderV2(RemotingCommand request) throws RemotingCommandException {
        SendMessageRequestHeaderV2 r = new SendMessageRequestHeaderV2();
        HashMap fields = request.getExtFields();
        if (fields == null) {
            throw new RemotingCommandException("the ext fields is null");
        }
        String s = (String)fields.get("a");
        SendMessageRequestHeader.checkNotNull(s, "the custom field <a> is null");
        r.setA(s);
        s = (String)fields.get("b");
        SendMessageRequestHeader.checkNotNull(s, "the custom field <b> is null");
        r.setB(s);
        s = (String)fields.get("c");
        SendMessageRequestHeader.checkNotNull(s, "the custom field <c> is null");
        r.setC(s);
        s = (String)fields.get("d");
        SendMessageRequestHeader.checkNotNull(s, "the custom field <d> is null");
        r.setD(Integer.parseInt(s));
        s = (String)fields.get("e");
        SendMessageRequestHeader.checkNotNull(s, "the custom field <e> is null");
        r.setE(Integer.parseInt(s));
        s = (String)fields.get("f");
        SendMessageRequestHeader.checkNotNull(s, "the custom field <f> is null");
        r.setF(Integer.parseInt(s));
        s = (String)fields.get("g");
        SendMessageRequestHeader.checkNotNull(s, "the custom field <g> is null");
        r.setG(Long.parseLong(s));
        s = (String)fields.get("h");
        SendMessageRequestHeader.checkNotNull(s, "the custom field <h> is null");
        r.setH(Integer.parseInt(s));
        s = (String)fields.get("i");
        if (s != null) {
            r.setI(s);
        }
        if ((s = (String)fields.get("j")) != null) {
            r.setJ(Integer.parseInt(s));
        }
        if ((s = (String)fields.get("k")) != null) {
            r.setK(Boolean.parseBoolean(s));
        }
        if ((s = (String)fields.get("l")) != null) {
            r.setL(Integer.parseInt(s));
        }
        if ((s = (String)fields.get("m")) != null) {
            r.setM(Boolean.parseBoolean(s));
        }
        return r;
    }

    private static void checkNotNull(String s, String msg) throws RemotingCommandException {
        if (s == null) {
            throw new RemotingCommandException(msg);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("producerGroup", (Object)this.producerGroup).add("topic", (Object)this.topic).add("defaultTopic", (Object)this.defaultTopic).add("defaultTopicQueueNums", (Object)this.defaultTopicQueueNums).add("queueId", (Object)this.queueId).add("sysFlag", (Object)this.sysFlag).add("bornTimestamp", (Object)this.bornTimestamp).add("flag", (Object)this.flag).add("properties", (Object)this.properties).add("reconsumeTimes", (Object)this.reconsumeTimes).add("unitMode", this.unitMode).add("batch", this.batch).add("maxReconsumeTimes", (Object)this.maxReconsumeTimes).toString();
    }
}

