/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.route;

import com.google.common.base.MoreObjects;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.route.QueueData;
import org.apache.rocketmq.proxy.service.route.AddressableMessageQueue;
import org.apache.rocketmq.proxy.service.route.TopicRouteWrapper;

public class MessageQueueSelector {
    private static final int BROKER_ACTING_QUEUE_ID = -1;
    private final List<AddressableMessageQueue> queues = new ArrayList<AddressableMessageQueue>();
    private final List<AddressableMessageQueue> brokerActingQueues = new ArrayList<AddressableMessageQueue>();
    private final Map<String, AddressableMessageQueue> brokerNameQueueMap = new ConcurrentHashMap<String, AddressableMessageQueue>();
    private final AtomicInteger queueIndex;
    private final AtomicInteger brokerIndex;

    public MessageQueueSelector(TopicRouteWrapper topicRouteWrapper, boolean read) {
        if (read) {
            this.queues.addAll(MessageQueueSelector.buildRead(topicRouteWrapper));
        } else {
            this.queues.addAll(MessageQueueSelector.buildWrite(topicRouteWrapper));
        }
        this.buildBrokerActingQueues(topicRouteWrapper.getTopicName(), this.queues);
        Random random = new Random();
        this.queueIndex = new AtomicInteger(random.nextInt());
        this.brokerIndex = new AtomicInteger(random.nextInt());
    }

    private static List<AddressableMessageQueue> buildRead(TopicRouteWrapper topicRoute) {
        HashSet<AddressableMessageQueue> queueSet = new HashSet<AddressableMessageQueue>();
        List<QueueData> qds = topicRoute.getQueueDatas();
        if (qds == null) {
            return new ArrayList<AddressableMessageQueue>();
        }
        for (QueueData qd : qds) {
            String brokerAddr;
            if (!PermName.isReadable((int)qd.getPerm()) || (brokerAddr = topicRoute.getMasterAddrPrefer(qd.getBrokerName())) == null) continue;
            for (int i = 0; i < qd.getReadQueueNums(); ++i) {
                AddressableMessageQueue mq = new AddressableMessageQueue(new MessageQueue(topicRoute.getTopicName(), qd.getBrokerName(), i), brokerAddr);
                queueSet.add(mq);
            }
        }
        return queueSet.stream().sorted().collect(Collectors.toList());
    }

    private static List<AddressableMessageQueue> buildWrite(TopicRouteWrapper topicRoute) {
        HashSet<AddressableMessageQueue> queueSet = new HashSet<AddressableMessageQueue>();
        if (StringUtils.isNotBlank((CharSequence)topicRoute.getOrderTopicConf())) {
            String[] brokers;
            for (String broker : brokers = topicRoute.getOrderTopicConf().split(";")) {
                String[] item = broker.split(":");
                String brokerName = item[0];
                String brokerAddr = topicRoute.getMasterAddr(brokerName);
                if (brokerAddr == null) continue;
                int nums = Integer.parseInt(item[1]);
                for (int i = 0; i < nums; ++i) {
                    AddressableMessageQueue mq = new AddressableMessageQueue(new MessageQueue(topicRoute.getTopicName(), brokerName, i), brokerAddr);
                    queueSet.add(mq);
                }
            }
        } else {
            List<QueueData> qds = topicRoute.getQueueDatas();
            if (qds == null) {
                return new ArrayList<AddressableMessageQueue>();
            }
            for (QueueData qd : qds) {
                String brokerAddr;
                if (!PermName.isWriteable((int)qd.getPerm()) || (brokerAddr = topicRoute.getMasterAddr(qd.getBrokerName())) == null) continue;
                for (int i = 0; i < qd.getWriteQueueNums(); ++i) {
                    AddressableMessageQueue mq = new AddressableMessageQueue(new MessageQueue(topicRoute.getTopicName(), qd.getBrokerName(), i), brokerAddr);
                    queueSet.add(mq);
                }
            }
        }
        return queueSet.stream().sorted().collect(Collectors.toList());
    }

    private void buildBrokerActingQueues(String topic, List<AddressableMessageQueue> normalQueues) {
        for (AddressableMessageQueue mq : normalQueues) {
            AddressableMessageQueue brokerActingQueue = new AddressableMessageQueue(new MessageQueue(topic, mq.getMessageQueue().getBrokerName(), -1), mq.getBrokerAddr());
            if (this.brokerActingQueues.contains(brokerActingQueue)) continue;
            this.brokerActingQueues.add(brokerActingQueue);
            this.brokerNameQueueMap.put(brokerActingQueue.getBrokerName(), brokerActingQueue);
        }
        Collections.sort(this.brokerActingQueues);
    }

    public AddressableMessageQueue getQueueByBrokerName(String brokerName) {
        return this.brokerNameQueueMap.get(brokerName);
    }

    public AddressableMessageQueue selectOne(boolean onlyBroker) {
        int nextIndex = onlyBroker ? this.brokerIndex.getAndIncrement() : this.queueIndex.getAndIncrement();
        return this.selectOneByIndex(nextIndex, onlyBroker);
    }

    public AddressableMessageQueue selectNextOne(AddressableMessageQueue last) {
        boolean onlyBroker = last.getQueueId() < 0;
        AddressableMessageQueue newOne = last;
        int count = onlyBroker ? this.brokerActingQueues.size() : this.queues.size();
        for (int i = 0; i < count && (newOne = this.selectOne(onlyBroker)).getBrokerName().equals(last.getBrokerName()) && newOne.getQueueId() == last.getQueueId(); ++i) {
        }
        return newOne;
    }

    public AddressableMessageQueue selectOneByIndex(int index, boolean onlyBroker) {
        if (onlyBroker) {
            if (this.brokerActingQueues.isEmpty()) {
                return null;
            }
            return this.brokerActingQueues.get(IntMath.mod((int)index, (int)this.brokerActingQueues.size()));
        }
        if (this.queues.isEmpty()) {
            return null;
        }
        return this.queues.get(IntMath.mod((int)index, (int)this.queues.size()));
    }

    public List<AddressableMessageQueue> getQueues() {
        return this.queues;
    }

    public List<AddressableMessageQueue> getBrokerActingQueues() {
        return this.brokerActingQueues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageQueueSelector)) {
            return false;
        }
        MessageQueueSelector queue = (MessageQueueSelector)o;
        return Objects.equals(this.queues, queue.queues) && Objects.equals(this.brokerActingQueues, queue.brokerActingQueues);
    }

    public int hashCode() {
        return Objects.hash(this.queues, this.brokerActingQueues);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queues", this.queues).add("brokerActingQueues", this.brokerActingQueues).add("brokerNameQueueMap", this.brokerNameQueueMap).add("queueIndex", (Object)this.queueIndex).add("brokerIndex", (Object)this.brokerIndex).toString();
    }
}

