/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.filter;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.rocketmq.broker.filter.ConsumerFilterData;
import org.apache.rocketmq.broker.filter.ConsumerFilterManager;
import org.apache.rocketmq.broker.filter.ExpressionMessageFilter;
import org.apache.rocketmq.broker.filter.MessageEvaluationContext;
import org.apache.rocketmq.common.filter.ExpressionType;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.filter.expression.EvaluationContext;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;

public class ExpressionForRetryMessageFilter
extends ExpressionMessageFilter {
    public ExpressionForRetryMessageFilter(SubscriptionData subscriptionData, ConsumerFilterData consumerFilterData, ConsumerFilterManager consumerFilterManager) {
        super(subscriptionData, consumerFilterData, consumerFilterManager);
    }

    @Override
    public boolean isMatchedByCommitLog(ByteBuffer msgBuffer, Map<String, String> properties) {
        if (this.subscriptionData == null) {
            return true;
        }
        if (this.subscriptionData.isClassFilterMode()) {
            return true;
        }
        boolean isRetryTopic = this.subscriptionData.getTopic().startsWith("%RETRY%");
        if (!isRetryTopic && ExpressionType.isTagType((String)this.subscriptionData.getExpressionType())) {
            return true;
        }
        ConsumerFilterData realFilterData = this.consumerFilterData;
        Map tempProperties = properties;
        boolean decoded = false;
        if (isRetryTopic) {
            if (tempProperties == null && msgBuffer != null) {
                decoded = true;
                tempProperties = MessageDecoder.decodeProperties((ByteBuffer)msgBuffer);
            }
            String realTopic = tempProperties.get("RETRY_TOPIC");
            String group = this.subscriptionData.getTopic().substring("%RETRY%".length());
            realFilterData = this.consumerFilterManager.get(realTopic, group);
        }
        if (realFilterData == null || realFilterData.getExpression() == null || realFilterData.getCompiledExpression() == null) {
            return true;
        }
        if (!decoded && tempProperties == null && msgBuffer != null) {
            tempProperties = MessageDecoder.decodeProperties((ByteBuffer)msgBuffer);
        }
        Object ret = null;
        try {
            MessageEvaluationContext context = new MessageEvaluationContext(tempProperties);
            ret = realFilterData.getCompiledExpression().evaluate((EvaluationContext)context);
        }
        catch (Throwable e) {
            log.error("Message Filter error, " + realFilterData + ", " + tempProperties, e);
        }
        log.debug("Pull eval result: {}, {}, {}", new Object[]{ret, realFilterData, tempProperties});
        if (ret == null || !(ret instanceof Boolean)) {
            return false;
        }
        return (Boolean)ret;
    }
}

