/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.common;

import java.util.concurrent.atomic.LongAdder;
import org.apache.rocketmq.store.SelectMappedBufferResult;

public class SelectMappedBufferResultWrapper {
    private final SelectMappedBufferResult result;
    private LongAdder accessCount = new LongAdder();
    private long curOffset;
    private long minOffset;
    private long maxOffset;
    private long size;

    public SelectMappedBufferResultWrapper(SelectMappedBufferResult result, long curOffset, long minOffset, long maxOffset, long size) {
        this.result = result;
        this.curOffset = curOffset;
        this.minOffset = minOffset;
        this.maxOffset = maxOffset;
        this.size = size;
    }

    public SelectMappedBufferResult getResult() {
        return this.result;
    }

    public SelectMappedBufferResult getDuplicateResult() {
        return new SelectMappedBufferResult(this.result.getStartOffset(), this.result.getByteBuffer().asReadOnlyBuffer(), this.result.getSize(), this.result.getMappedFile());
    }

    public long getCurOffset() {
        return this.curOffset;
    }

    public void setCurOffset(long curOffset) {
        this.curOffset = curOffset;
    }

    public long getMinOffset() {
        return this.minOffset;
    }

    public long getMaxOffset() {
        return this.maxOffset;
    }

    public long getSize() {
        return this.size;
    }

    public void addAccessCount() {
        this.accessCount.increment();
    }

    public long getAccessCount() {
        return this.accessCount.sum();
    }
}

