/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.provider.inputstream;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.provider.inputstream.TieredCommitLogInputStream;
import org.apache.rocketmq.tieredstore.provider.inputstream.TieredFileSegmentInputStream;

public class TieredFileSegmentInputStreamFactory {
    public static TieredFileSegmentInputStream build(FileSegmentType fileType, long startOffset, List<ByteBuffer> uploadBufferList, ByteBuffer codaBuffer, int contentLength) {
        switch (fileType) {
            case COMMIT_LOG: {
                return new TieredCommitLogInputStream(fileType, startOffset, uploadBufferList, codaBuffer, contentLength);
            }
            case CONSUME_QUEUE: {
                return new TieredFileSegmentInputStream(fileType, uploadBufferList, contentLength);
            }
            case INDEX: {
                if (uploadBufferList.size() != 1) {
                    throw new IllegalArgumentException("uploadBufferList size in INDEX type input stream must be 1");
                }
                return new TieredFileSegmentInputStream(fileType, uploadBufferList, contentLength);
            }
        }
        throw new IllegalArgumentException("fileType is not supported");
    }
}

