/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.utils;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.rocketmq.common.message.MessageExt;

public class MessageUtils {
    public static int getShardingKeyIndex(String shardingKey, int indexSize) {
        return Math.abs(Hashing.murmur3_32().hashBytes(shardingKey.getBytes(StandardCharsets.UTF_8)).asInt() % indexSize);
    }

    public static int getShardingKeyIndexByMsg(MessageExt msg, int indexSize) {
        String shardingKey = msg.getProperty("__SHARDINGKEY");
        if (shardingKey == null) {
            shardingKey = "";
        }
        return MessageUtils.getShardingKeyIndex(shardingKey, indexSize);
    }

    public static Set<Integer> getShardingKeyIndexes(Collection<MessageExt> msgs, int indexSize) {
        HashSet<Integer> indexSet = new HashSet<Integer>(indexSize);
        for (MessageExt msg : msgs) {
            indexSet.add(MessageUtils.getShardingKeyIndexByMsg(msg, indexSize));
        }
        return indexSet;
    }
}

