/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.topic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.topic.TopicConfigManager;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.config.RocksDBConfigManager;
import org.apache.rocketmq.common.utils.DataConverter;

public class RocksDBTopicConfigManager
extends TopicConfigManager {
    public RocksDBTopicConfigManager(BrokerController brokerController) {
        super(brokerController, false);
        this.rocksDBConfigManager = new RocksDBConfigManager(brokerController.getMessageStoreConfig().getMemTableFlushIntervalMs());
    }

    public boolean load() {
        if (!this.rocksDBConfigManager.load(this.configFilePath(), this::decode0)) {
            return false;
        }
        this.init();
        return true;
    }

    public boolean stop() {
        return this.rocksDBConfigManager.stop();
    }

    protected void decode0(byte[] key, byte[] body) {
        String topicName = new String(key, DataConverter.CHARSET_UTF8);
        TopicConfig topicConfig = (TopicConfig)JSON.parseObject((byte[])body, TopicConfig.class, (Feature[])new Feature[0]);
        this.topicConfigTable.put(topicName, topicConfig);
        log.info("load exist local topic, {}", (Object)topicConfig.toString());
    }

    @Override
    public String configFilePath() {
        return this.brokerController.getMessageStoreConfig().getStorePathRootDir() + File.separator + "config" + File.separator + "topics" + File.separator;
    }

    @Override
    protected TopicConfig putTopicConfig(TopicConfig topicConfig) {
        String topicName = topicConfig.getTopicName();
        TopicConfig oldTopicConfig = this.topicConfigTable.put(topicName, topicConfig);
        try {
            byte[] keyBytes = topicName.getBytes(DataConverter.CHARSET_UTF8);
            byte[] valueBytes = JSON.toJSONBytes((Object)topicConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
            this.rocksDBConfigManager.put(keyBytes, keyBytes.length, valueBytes);
        }
        catch (Exception e) {
            log.error("kv put topic Failed, {}", (Object)topicConfig.toString(), (Object)e);
        }
        return oldTopicConfig;
    }

    @Override
    protected TopicConfig removeTopicConfig(String topicName) {
        TopicConfig topicConfig = (TopicConfig)this.topicConfigTable.remove(topicName);
        try {
            this.rocksDBConfigManager.delete(topicName.getBytes(DataConverter.CHARSET_UTF8));
        }
        catch (Exception e) {
            log.error("kv remove topic Failed, {}", (Object)topicConfig.toString());
        }
        return topicConfig;
    }

    public synchronized void persist() {
        if (this.brokerController.getMessageStoreConfig().isRealTimePersistRocksDBConfig()) {
            this.rocksDBConfigManager.flushWAL();
        }
    }
}

