/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.logfile.MappedFile;
import org.apache.rocketmq.store.queue.BatchConsumeQueue;
import org.apache.rocketmq.store.queue.BatchOffsetIndex;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.ReferredIterator;

public class SparseConsumeQueue
extends BatchConsumeQueue {
    public SparseConsumeQueue(String topic, int queueId, String storePath, int mappedFileSize, MessageStore defaultMessageStore) {
        super(topic, queueId, storePath, mappedFileSize, defaultMessageStore);
    }

    public SparseConsumeQueue(String topic, int queueId, String storePath, int mappedFileSize, MessageStore defaultMessageStore, String subfolder) {
        super(topic, queueId, storePath, mappedFileSize, defaultMessageStore, subfolder);
    }

    @Override
    public void recover() {
        List<MappedFile> mappedFiles = this.mappedFileQueue.getMappedFiles();
        if (!mappedFiles.isEmpty()) {
            int index = mappedFiles.size() - 3;
            if (index < 0) {
                index = 0;
            }
            MappedFile mappedFile = mappedFiles.get(index);
            ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
            int mappedFileOffset = 0;
            long processOffset = mappedFile.getFileFromOffset();
            while (true) {
                for (int i = 0; i < this.mappedFileSize; i += 46) {
                    byteBuffer.position(i);
                    long offset = byteBuffer.getLong();
                    int size = byteBuffer.getInt();
                    byteBuffer.getLong();
                    byteBuffer.getLong();
                    long msgBaseOffset = byteBuffer.getLong();
                    short batchSize = byteBuffer.getShort();
                    if (offset >= 0L && size > 0 && msgBaseOffset >= 0L && batchSize > 0) {
                        mappedFileOffset += 46;
                    } else {
                        log.info("Recover current batch consume queue file over, file:{} offset:{} size:{} msgBaseOffset:{} batchSize:{} mappedFileOffset:{}", new Object[]{mappedFile.getFileName(), offset, size, msgBaseOffset, batchSize, mappedFileOffset});
                        if (mappedFileOffset == this.mappedFileSize) break;
                        mappedFile.setWrotePosition(mappedFileOffset);
                        mappedFile.setFlushedPosition(mappedFileOffset);
                        mappedFile.setCommittedPosition(mappedFileOffset);
                        break;
                    }
                    this.maxMsgPhyOffsetInCommitLog = offset;
                }
                if (++index >= mappedFiles.size()) break;
                mappedFile = mappedFiles.get(index);
                byteBuffer = mappedFile.sliceByteBuffer();
                processOffset = mappedFile.getFileFromOffset();
                mappedFileOffset = 0;
                log.info("Recover next batch consume queue file: " + mappedFile.getFileName());
            }
            log.info("Recover last batch consume queue file over, last mapped file:{} ", (Object)mappedFile.getFileName());
            this.mappedFileQueue.setFlushedWhere(processOffset += (long)mappedFileOffset);
            this.mappedFileQueue.setCommittedWhere(processOffset);
            this.mappedFileQueue.truncateDirtyFiles(processOffset);
            this.reviseMaxAndMinOffsetInQueue();
        }
    }

    public ReferredIterator<CqUnit> iterateFromOrNext(long startOffset) {
        SelectMappedBufferResult sbr = this.getBatchMsgIndexOrNextBuffer(startOffset);
        if (sbr == null) {
            return null;
        }
        return new BatchConsumeQueue.BatchConsumeQueueIterator(sbr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectMappedBufferResult getBatchMsgIndexOrNextBuffer(long msgOffset) {
        MappedFile targetBcq = msgOffset <= this.minOffsetInQueue ? this.mappedFileQueue.getFirstMappedFile() : this.searchFileByOffsetOrRight(msgOffset);
        if (targetBcq == null) {
            return null;
        }
        BatchOffsetIndex minOffset = this.getMinMsgOffset(targetBcq, false, false);
        BatchOffsetIndex maxOffset = this.getMaxMsgOffset(targetBcq, false, false);
        if (null == minOffset || null == maxOffset) {
            return null;
        }
        SelectMappedBufferResult sbr = minOffset.getMappedFile().selectMappedBuffer(0);
        try {
            ByteBuffer byteBuffer = sbr.getByteBuffer();
            int left = minOffset.getIndexPos();
            int right = maxOffset.getIndexPos();
            int mid = SparseConsumeQueue.binarySearchRight(byteBuffer, left, right, 46, 28, msgOffset, BoundaryType.LOWER);
            if (mid != -1) {
                SelectMappedBufferResult selectMappedBufferResult = minOffset.getMappedFile().selectMappedBuffer(mid);
                return selectMappedBufferResult;
            }
        }
        finally {
            sbr.release();
        }
        return null;
    }

    protected MappedFile searchOffsetFromCacheOrRight(long msgOffset) {
        Map.Entry ceilingEntry = this.offsetCache.ceilingEntry(msgOffset);
        if (ceilingEntry == null) {
            return null;
        }
        return (MappedFile)ceilingEntry.getValue();
    }

    protected MappedFile searchFileByOffsetOrRight(long msgOffset) {
        MappedFile targetBcq = null;
        boolean searchBcqByCacheEnable = this.messageStore.getMessageStoreConfig().isSearchBcqByCacheEnable();
        if (searchBcqByCacheEnable) {
            targetBcq = this.searchOffsetFromCacheOrRight(msgOffset);
            if (targetBcq == null) {
                MappedFile firstBcq = this.mappedFileQueue.getFirstMappedFile();
                BatchOffsetIndex minForFirstBcq = this.getMinMsgOffset(firstBcq, false, false);
                if (minForFirstBcq != null && minForFirstBcq.getMsgOffset() <= msgOffset && msgOffset < this.maxOffsetInQueue) {
                    targetBcq = this.searchOffsetFromFilesOrRight(msgOffset);
                }
                log.warn("cache is not working on BCQ [Topic: {}, QueueId: {}] for msgOffset: {}, targetBcq: {}", new Object[]{this.topic, this.queueId, msgOffset, targetBcq});
            }
        } else {
            targetBcq = this.searchOffsetFromFilesOrRight(msgOffset);
        }
        return targetBcq;
    }

    public MappedFile searchOffsetFromFilesOrRight(long msgOffset) {
        MappedFile targetBcq = null;
        int mappedFileNum = this.mappedFileQueue.getMappedFiles().size();
        for (int i = mappedFileNum - 1; i >= 0; --i) {
            MappedFile mappedFile = this.mappedFileQueue.getMappedFiles().get(i);
            BatchOffsetIndex tmpMinMsgOffset = this.getMinMsgOffset(mappedFile, false, false);
            BatchOffsetIndex tmpMaxMsgOffset = this.getMaxMsgOffset(mappedFile, false, false);
            if (null != tmpMaxMsgOffset && tmpMaxMsgOffset.getMsgOffset() < msgOffset && i != mappedFileNum - 1) {
                targetBcq = this.mappedFileQueue.getMappedFiles().get(i + 1);
                break;
            }
            if (null == tmpMinMsgOffset || tmpMinMsgOffset.getMsgOffset() > msgOffset || null == tmpMaxMsgOffset || msgOffset > tmpMaxMsgOffset.getMsgOffset()) continue;
            targetBcq = mappedFile;
            break;
        }
        return targetBcq;
    }

    private MappedFile getPreFile(MappedFile file) {
        int index = this.mappedFileQueue.getMappedFiles().indexOf(file);
        if (index < 1) {
            return null;
        }
        return this.mappedFileQueue.getMappedFiles().get(index - 1);
    }

    private void cacheOffset(MappedFile file, Function<MappedFile, BatchOffsetIndex> offsetGetFunc) {
        try {
            BatchOffsetIndex offset = offsetGetFunc.apply(file);
            if (offset != null) {
                this.offsetCache.put(offset.getMsgOffset(), offset.getMappedFile());
                this.timeCache.put(offset.getStoreTimestamp(), offset.getMappedFile());
            }
        }
        catch (Exception e) {
            log.error("Failed caching offset and time on BCQ [Topic: {}, QueueId: {}, File: {}]", new Object[]{this.topic, this.queueId, file});
        }
    }

    @Override
    protected void cacheBcq(MappedFile bcq) {
        MappedFile file = this.getPreFile(bcq);
        if (file != null) {
            this.cacheOffset(file, m -> this.getMaxMsgOffset((MappedFile)m, false, true));
        }
    }

    public void putEndPositionInfo(MappedFile mappedFile) {
        if (!mappedFile.isFull()) {
            this.byteBufferItem.flip();
            this.byteBufferItem.limit(46);
            this.byteBufferItem.putLong(-1L);
            this.byteBufferItem.putInt(0);
            this.byteBufferItem.putLong(0L);
            this.byteBufferItem.putLong(0L);
            this.byteBufferItem.putLong(0L);
            this.byteBufferItem.putShort((short)0);
            this.byteBufferItem.putInt(-1);
            this.byteBufferItem.putInt(0);
            boolean appendRes = mappedFile.appendMessage(this.byteBufferItem.array());
            if (!appendRes) {
                log.error("append end position info into {} failed", (Object)mappedFile.getFileName());
            }
        }
        this.cacheOffset(mappedFile, m -> this.getMaxMsgOffset((MappedFile)m, false, true));
    }

    public MappedFile createFile(long physicalOffset) throws IOException {
        return this.mappedFileQueue.tryCreateMappedFile(physicalOffset);
    }

    public boolean isLastFileFull() {
        if (this.mappedFileQueue.getLastMappedFile() != null) {
            return this.mappedFileQueue.getLastMappedFile().isFull();
        }
        return true;
    }

    public boolean shouldRoll() {
        if (this.mappedFileQueue.getLastMappedFile() == null) {
            return true;
        }
        if (this.mappedFileQueue.getLastMappedFile().isFull()) {
            return true;
        }
        return this.mappedFileQueue.getLastMappedFile().getWrotePosition() + 46 > this.mappedFileQueue.getMappedFileSize();
    }

    public boolean containsOffsetFile(long physicalOffset) {
        String fileName = UtilAll.offset2FileName((long)physicalOffset);
        return this.mappedFileQueue.getMappedFiles().stream().anyMatch(mf -> Objects.equals(mf.getFile().getName(), fileName));
    }

    public long getMaxPhyOffsetInLog() {
        MappedFile lastMappedFile = this.mappedFileQueue.getLastMappedFile();
        Long maxOffsetInLog = this.getMax(lastMappedFile, b -> b.getLong(0) + (long)b.getInt(8));
        if (maxOffsetInLog != null) {
            return maxOffsetInLog;
        }
        return -1L;
    }

    private <T> T getMax(MappedFile mappedFile, Function<ByteBuffer, T> function) {
        if (mappedFile == null || mappedFile.getReadPosition() < 46) {
            return null;
        }
        ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
        for (int i = mappedFile.getReadPosition() - 46; i >= 0; i -= 46) {
            byteBuffer.position(i);
            long offset = byteBuffer.getLong();
            int size = byteBuffer.getInt();
            long tagsCode = byteBuffer.getLong();
            long timestamp = byteBuffer.getLong();
            long msgBaseOffset = byteBuffer.getLong();
            short batchSize = byteBuffer.getShort();
            if (offset < 0L || size <= 0 || msgBaseOffset < 0L || batchSize <= 0) continue;
            byteBuffer.position(i);
            return function.apply(byteBuffer.slice());
        }
        return null;
    }

    @Override
    protected BatchOffsetIndex getMaxMsgOffset(MappedFile mappedFile, boolean getBatchSize, boolean getStoreTime) {
        if (mappedFile == null || mappedFile.getReadPosition() < 46) {
            return null;
        }
        ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
        for (int i = mappedFile.getReadPosition() - 46; i >= 0; i -= 46) {
            byteBuffer.position(i);
            long offset = byteBuffer.getLong();
            int size = byteBuffer.getInt();
            byteBuffer.getLong();
            long timestamp = byteBuffer.getLong();
            long msgBaseOffset = byteBuffer.getLong();
            short batchSize = byteBuffer.getShort();
            if (offset < 0L || size <= 0 || msgBaseOffset < 0L || batchSize <= 0) continue;
            return new BatchOffsetIndex(mappedFile, i, msgBaseOffset, batchSize, timestamp);
        }
        return null;
    }

    public long getMaxMsgOffsetFromFile(String simpleFileName) {
        MappedFile mappedFile = this.mappedFileQueue.getMappedFiles().stream().filter(m -> Objects.equals(m.getFile().getName(), simpleFileName)).findFirst().orElse(null);
        if (mappedFile == null) {
            return -1L;
        }
        BatchOffsetIndex max = this.getMaxMsgOffset(mappedFile, false, false);
        if (max == null) {
            return -1L;
        }
        return max.getMsgOffset();
    }

    private void refreshMaxCache() {
        this.doRefreshCache(m -> this.getMaxMsgOffset((MappedFile)m, false, true));
    }

    @Override
    protected void refreshCache() {
        this.refreshMaxCache();
    }

    public void refresh() {
        this.reviseMaxAndMinOffsetInQueue();
        this.refreshCache();
    }
}

