/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.rocksdb;

import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.config.AbstractRocksDBStorage;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.rocksdb.RocksDBOptionsFactory;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactRangeOptions;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class ConsumeQueueRocksDBStorage
extends AbstractRocksDBStorage {
    private final MessageStore messageStore;
    private volatile ColumnFamilyHandle offsetCFHandle;

    public ConsumeQueueRocksDBStorage(MessageStore messageStore, String dbPath, int prefixLen) {
        this.messageStore = messageStore;
        this.dbPath = dbPath;
        this.readOnly = false;
    }

    private void initOptions() {
        this.options = RocksDBOptionsFactory.createDBOptions();
        this.writeOptions = new WriteOptions();
        this.writeOptions.setSync(false);
        this.writeOptions.setDisableWAL(true);
        this.writeOptions.setNoSlowdown(true);
        this.totalOrderReadOptions = new ReadOptions();
        this.totalOrderReadOptions.setPrefixSameAsStart(false);
        this.totalOrderReadOptions.setTotalOrderSeek(false);
        this.compactRangeOptions = new CompactRangeOptions();
        this.compactRangeOptions.setBottommostLevelCompaction(CompactRangeOptions.BottommostLevelCompaction.kForce);
        this.compactRangeOptions.setAllowWriteStall(true);
        this.compactRangeOptions.setExclusiveManualCompaction(false);
        this.compactRangeOptions.setChangeLevel(true);
        this.compactRangeOptions.setTargetLevel(-1);
        this.compactRangeOptions.setMaxSubcompactions(4);
    }

    protected boolean postLoad() {
        try {
            UtilAll.ensureDirOK((String)this.dbPath);
            this.initOptions();
            ArrayList<ColumnFamilyDescriptor> cfDescriptors = new ArrayList<ColumnFamilyDescriptor>();
            ColumnFamilyOptions cqCfOptions = RocksDBOptionsFactory.createCQCFOptions(this.messageStore);
            this.cfOptions.add(cqCfOptions);
            cfDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, cqCfOptions));
            ColumnFamilyOptions offsetCfOptions = RocksDBOptionsFactory.createOffsetCFOptions();
            this.cfOptions.add(offsetCfOptions);
            cfDescriptors.add(new ColumnFamilyDescriptor("offset".getBytes(DataConverter.CHARSET_UTF8), offsetCfOptions));
            ArrayList cfHandles = new ArrayList();
            this.open(cfDescriptors, cfHandles);
            this.defaultCFHandle = (ColumnFamilyHandle)cfHandles.get(0);
            this.offsetCFHandle = (ColumnFamilyHandle)cfHandles.get(1);
        }
        catch (Exception e) {
            LOGGER.error("postLoad Failed. {}", (Object)this.dbPath, (Object)e);
            return false;
        }
        return true;
    }

    protected void preShutdown() {
        this.offsetCFHandle.close();
    }

    public byte[] getCQ(byte[] keyBytes) throws RocksDBException {
        return this.get(this.defaultCFHandle, this.totalOrderReadOptions, keyBytes);
    }

    public byte[] getOffset(byte[] keyBytes) throws RocksDBException {
        return this.get(this.offsetCFHandle, this.totalOrderReadOptions, keyBytes);
    }

    public List<byte[]> multiGet(List<ColumnFamilyHandle> cfhList, List<byte[]> keys) throws RocksDBException {
        return this.multiGet(this.totalOrderReadOptions, cfhList, keys);
    }

    public void batchPut(WriteBatch batch) throws RocksDBException {
        this.batchPut(this.writeOptions, batch);
    }

    public void manualCompaction(long minPhyOffset) {
        try {
            this.manualCompaction(minPhyOffset, this.compactRangeOptions);
        }
        catch (Exception e) {
            LOGGER.error("manualCompaction Failed. minPhyOffset: {}", (Object)minPhyOffset, (Object)e);
        }
    }

    public RocksIterator seekOffsetCF() {
        return this.db.newIterator(this.offsetCFHandle, this.totalOrderReadOptions);
    }

    public ColumnFamilyHandle getOffsetCFHandle() {
        return this.offsetCFHandle;
    }
}

