/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.body.ProcessQueueInfo;

public class ProcessQueue {
    public static final long REBALANCE_LOCK_MAX_LIVE_TIME = Long.parseLong(System.getProperty("rocketmq.client.rebalance.lockMaxLiveTime", "30000"));
    public static final long REBALANCE_LOCK_INTERVAL = Long.parseLong(System.getProperty("rocketmq.client.rebalance.lockInterval", "20000"));
    private static final long PULL_MAX_IDLE_TIME = Long.parseLong(System.getProperty("rocketmq.client.pull.pullMaxIdleTime", "120000"));
    private final Logger log = LoggerFactory.getLogger(ProcessQueue.class);
    private final ReadWriteLock treeMapLock = new ReentrantReadWriteLock();
    private final TreeMap<Long, MessageExt> msgTreeMap = new TreeMap();
    private final AtomicLong msgCount = new AtomicLong();
    private final AtomicLong msgSize = new AtomicLong();
    private final ReadWriteLock consumeLock = new ReentrantReadWriteLock();
    private final TreeMap<Long, MessageExt> consumingMsgOrderlyTreeMap = new TreeMap();
    private final AtomicLong tryUnlockTimes = new AtomicLong(0L);
    private volatile long queueOffsetMax = 0L;
    private volatile boolean dropped = false;
    private volatile long lastPullTimestamp = System.currentTimeMillis();
    private volatile long lastConsumeTimestamp = System.currentTimeMillis();
    private volatile boolean locked = false;
    private volatile long lastLockTimestamp = System.currentTimeMillis();
    private volatile boolean consuming = false;
    private volatile long msgAccCnt = 0L;

    public boolean isLockExpired() {
        return System.currentTimeMillis() - this.lastLockTimestamp > REBALANCE_LOCK_MAX_LIVE_TIME;
    }

    public boolean isPullExpired() {
        return System.currentTimeMillis() - this.lastPullTimestamp > PULL_MAX_IDLE_TIME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanExpiredMsg(DefaultMQPushConsumer pushConsumer) {
        if (pushConsumer.isConsumeOrderly()) {
            return;
        }
        int loop = Math.min(this.msgTreeMap.size(), 16);
        for (int i = 0; i < loop; ++i) {
            MessageExt msg = null;
            try {
                this.treeMapLock.readLock().lockInterruptibly();
                try {
                    String consumeStartTimeStamp;
                    if (!this.msgTreeMap.isEmpty() && StringUtils.isNotEmpty((CharSequence)(consumeStartTimeStamp = MessageAccessor.getConsumeStartTimeStamp((Message)((Message)this.msgTreeMap.firstEntry().getValue())))) && System.currentTimeMillis() - Long.parseLong(consumeStartTimeStamp) > pushConsumer.getConsumeTimeout() * 60L * 1000L) {
                        msg = this.msgTreeMap.firstEntry().getValue();
                    }
                }
                finally {
                    this.treeMapLock.readLock().unlock();
                }
            }
            catch (InterruptedException e) {
                this.log.error("getExpiredMsg exception", (Throwable)e);
            }
            if (msg == null) break;
            try {
                pushConsumer.sendMessageBack(msg, 3);
                this.log.info("send expire msg back. topic={}, msgId={}, storeHost={}, queueId={}, queueOffset={}", new Object[]{msg.getTopic(), msg.getMsgId(), msg.getStoreHost(), msg.getQueueId(), msg.getQueueOffset()});
                try {
                    this.treeMapLock.writeLock().lockInterruptibly();
                    try {
                        if (this.msgTreeMap.isEmpty() || msg.getQueueOffset() != this.msgTreeMap.firstKey().longValue()) continue;
                        try {
                            this.removeMessage(Collections.singletonList(msg));
                        }
                        catch (Exception e) {
                            this.log.error("send expired msg exception", (Throwable)e);
                        }
                    }
                    finally {
                        this.treeMapLock.writeLock().unlock();
                    }
                }
                catch (InterruptedException e) {
                    this.log.error("getExpiredMsg exception", (Throwable)e);
                }
                continue;
            }
            catch (Exception e) {
                this.log.error("send expired msg exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putMessage(List<MessageExt> msgs) {
        boolean dispatchToConsume = false;
        try {
            this.treeMapLock.writeLock().lockInterruptibly();
            try {
                long accTotal;
                MessageExt messageExt;
                String property;
                int validMsgCnt = 0;
                for (MessageExt msg : msgs) {
                    MessageExt old = this.msgTreeMap.put(msg.getQueueOffset(), msg);
                    if (null != old) continue;
                    ++validMsgCnt;
                    this.queueOffsetMax = msg.getQueueOffset();
                    this.msgSize.addAndGet(msg.getBody().length);
                }
                this.msgCount.addAndGet(validMsgCnt);
                if (!this.msgTreeMap.isEmpty() && !this.consuming) {
                    dispatchToConsume = true;
                    this.consuming = true;
                }
                if (!msgs.isEmpty() && (property = (messageExt = msgs.get(msgs.size() - 1)).getProperty("MAX_OFFSET")) != null && (accTotal = Long.parseLong(property) - messageExt.getQueueOffset()) > 0L) {
                    this.msgAccCnt = accTotal;
                }
            }
            finally {
                this.treeMapLock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("putMessage exception", (Throwable)e);
        }
        return dispatchToConsume;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMaxSpan() {
        try {
            this.treeMapLock.readLock().lockInterruptibly();
            try {
                if (this.msgTreeMap.isEmpty()) return 0L;
                long l = this.msgTreeMap.lastKey() - this.msgTreeMap.firstKey();
                return l;
            }
            finally {
                this.treeMapLock.readLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("getMaxSpan exception", (Throwable)e);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long removeMessage(List<MessageExt> msgs) {
        long result = -1L;
        long now = System.currentTimeMillis();
        try {
            this.treeMapLock.writeLock().lockInterruptibly();
            this.lastConsumeTimestamp = now;
            try {
                if (!this.msgTreeMap.isEmpty()) {
                    result = this.queueOffsetMax + 1L;
                    int removedCnt = 0;
                    for (MessageExt msg : msgs) {
                        MessageExt prev = this.msgTreeMap.remove(msg.getQueueOffset());
                        if (prev == null) continue;
                        --removedCnt;
                        this.msgSize.addAndGet(-msg.getBody().length);
                    }
                    if (this.msgCount.addAndGet(removedCnt) == 0L) {
                        this.msgSize.set(0L);
                    }
                    if (!this.msgTreeMap.isEmpty()) {
                        result = this.msgTreeMap.firstKey();
                    }
                }
            }
            finally {
                this.treeMapLock.writeLock().unlock();
            }
        }
        catch (Throwable t) {
            this.log.error("removeMessage exception", t);
        }
        return result;
    }

    public TreeMap<Long, MessageExt> getMsgTreeMap() {
        return this.msgTreeMap;
    }

    public AtomicLong getMsgCount() {
        return this.msgCount;
    }

    public AtomicLong getMsgSize() {
        return this.msgSize;
    }

    public boolean isDropped() {
        return this.dropped;
    }

    public void setDropped(boolean dropped) {
        this.dropped = dropped;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void rollback() {
        try {
            this.treeMapLock.writeLock().lockInterruptibly();
            try {
                this.msgTreeMap.putAll(this.consumingMsgOrderlyTreeMap);
                this.consumingMsgOrderlyTreeMap.clear();
            }
            finally {
                this.treeMapLock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("rollback exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long commit() {
        try {
            this.treeMapLock.writeLock().lockInterruptibly();
            try {
                Long offset = this.consumingMsgOrderlyTreeMap.lastKey();
                if (this.msgCount.addAndGet(-this.consumingMsgOrderlyTreeMap.size()) == 0L) {
                    this.msgSize.set(0L);
                } else {
                    for (MessageExt msg : this.consumingMsgOrderlyTreeMap.values()) {
                        this.msgSize.addAndGet(-msg.getBody().length);
                    }
                }
                this.consumingMsgOrderlyTreeMap.clear();
                if (offset == null) return -1L;
                long l = offset + 1L;
                return l;
            }
            finally {
                this.treeMapLock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("commit exception", (Throwable)e);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeMessageToConsumeAgain(List<MessageExt> msgs) {
        try {
            this.treeMapLock.writeLock().lockInterruptibly();
            try {
                for (MessageExt msg : msgs) {
                    this.consumingMsgOrderlyTreeMap.remove(msg.getQueueOffset());
                    this.msgTreeMap.put(msg.getQueueOffset(), msg);
                }
            }
            finally {
                this.treeMapLock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("makeMessageToCosumeAgain exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageExt> takeMessages(int batchSize) {
        ArrayList<MessageExt> result = new ArrayList<MessageExt>(batchSize);
        long now = System.currentTimeMillis();
        try {
            this.treeMapLock.writeLock().lockInterruptibly();
            this.lastConsumeTimestamp = now;
            try {
                if (!this.msgTreeMap.isEmpty()) {
                    Map.Entry<Long, MessageExt> entry;
                    for (int i = 0; i < batchSize && (entry = this.msgTreeMap.pollFirstEntry()) != null; ++i) {
                        result.add(entry.getValue());
                        this.consumingMsgOrderlyTreeMap.put(entry.getKey(), entry.getValue());
                    }
                }
                if (result.isEmpty()) {
                    this.consuming = false;
                }
            }
            finally {
                this.treeMapLock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("take Messages exception", (Throwable)e);
        }
        return result;
    }

    public boolean containsMessage(MessageExt message) {
        if (message == null) {
            return false;
        }
        this.treeMapLock.readLock().lockInterruptibly();
        try {
            boolean bl = this.msgTreeMap.containsKey(message.getQueueOffset());
            this.treeMapLock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.treeMapLock.readLock().unlock();
                throw throwable;
            }
            catch (Throwable t) {
                this.log.error("Failed to check message's existence in process queue, message={}", (Object)message, (Object)t);
                return false;
            }
        }
    }

    public boolean hasTempMessage() {
        this.treeMapLock.readLock().lockInterruptibly();
        try {
            boolean bl = !this.msgTreeMap.isEmpty();
            this.treeMapLock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.treeMapLock.readLock().unlock();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
        }
    }

    public void clear() {
        try {
            this.treeMapLock.writeLock().lockInterruptibly();
            try {
                this.msgTreeMap.clear();
                this.consumingMsgOrderlyTreeMap.clear();
                this.msgCount.set(0L);
                this.msgSize.set(0L);
                this.queueOffsetMax = 0L;
            }
            finally {
                this.treeMapLock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("rollback exception", (Throwable)e);
        }
    }

    public long getLastLockTimestamp() {
        return this.lastLockTimestamp;
    }

    public void setLastLockTimestamp(long lastLockTimestamp) {
        this.lastLockTimestamp = lastLockTimestamp;
    }

    public ReadWriteLock getConsumeLock() {
        return this.consumeLock;
    }

    public long getLastPullTimestamp() {
        return this.lastPullTimestamp;
    }

    public void setLastPullTimestamp(long lastPullTimestamp) {
        this.lastPullTimestamp = lastPullTimestamp;
    }

    public long getMsgAccCnt() {
        return this.msgAccCnt;
    }

    public void setMsgAccCnt(long msgAccCnt) {
        this.msgAccCnt = msgAccCnt;
    }

    public long getTryUnlockTimes() {
        return this.tryUnlockTimes.get();
    }

    public void incTryUnlockTimes() {
        this.tryUnlockTimes.incrementAndGet();
    }

    public void fillProcessQueueInfo(ProcessQueueInfo info) {
        try {
            this.treeMapLock.readLock().lockInterruptibly();
            if (!this.msgTreeMap.isEmpty()) {
                info.setCachedMsgMinOffset(this.msgTreeMap.firstKey().longValue());
                info.setCachedMsgMaxOffset(this.msgTreeMap.lastKey().longValue());
                info.setCachedMsgCount(this.msgTreeMap.size());
            }
            info.setCachedMsgSizeInMiB((int)(this.msgSize.get() / 0x100000L));
            if (!this.consumingMsgOrderlyTreeMap.isEmpty()) {
                info.setTransactionMsgMinOffset(this.consumingMsgOrderlyTreeMap.firstKey().longValue());
                info.setTransactionMsgMaxOffset(this.consumingMsgOrderlyTreeMap.lastKey().longValue());
                info.setTransactionMsgCount(this.consumingMsgOrderlyTreeMap.size());
            }
            info.setLocked(this.locked);
            info.setTryUnlockTimes(this.tryUnlockTimes.get());
            info.setLastLockTimestamp(this.lastLockTimestamp);
            info.setDroped(this.dropped);
            info.setLastPullTimestamp(this.lastPullTimestamp);
            info.setLastConsumeTimestamp(this.lastConsumeTimestamp);
        }
        catch (Exception exception) {
        }
        finally {
            this.treeMapLock.readLock().unlock();
        }
    }

    public long getLastConsumeTimestamp() {
        return this.lastConsumeTimestamp;
    }

    public void setLastConsumeTimestamp(long lastConsumeTimestamp) {
        this.lastConsumeTimestamp = lastConsumeTimestamp;
    }
}

