/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.topic;

import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.topic.RocksDBTopicConfigManager;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.TopicConfig;

public class RocksDBLmqTopicConfigManager
extends RocksDBTopicConfigManager {
    public RocksDBLmqTopicConfigManager(BrokerController brokerController) {
        super(brokerController);
    }

    @Override
    public TopicConfig selectTopicConfig(String topic) {
        if (MixAll.isLmq((String)topic)) {
            return this.simpleLmqTopicConfig(topic);
        }
        return super.selectTopicConfig(topic);
    }

    @Override
    public void updateTopicConfig(TopicConfig topicConfig) {
        if (topicConfig == null || MixAll.isLmq((String)topicConfig.getTopicName())) {
            return;
        }
        super.updateTopicConfig(topicConfig);
    }

    @Override
    public boolean containsTopic(String topic) {
        if (MixAll.isLmq((String)topic)) {
            return true;
        }
        return super.containsTopic(topic);
    }

    private TopicConfig simpleLmqTopicConfig(String topic) {
        return new TopicConfig(topic, 1, 1, 6);
    }
}

