/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.route;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.QueueData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;

public class TopicRouteWrapper {
    private final TopicRouteData topicRouteData;
    private final String topicName;
    private final Map<String, BrokerData> brokerNameRouteData = new HashMap<String, BrokerData>();

    public TopicRouteWrapper(TopicRouteData topicRouteData, String topicName) {
        this.topicRouteData = topicRouteData;
        this.topicName = topicName;
        if (this.topicRouteData.getBrokerDatas() != null) {
            for (BrokerData brokerData : this.topicRouteData.getBrokerDatas()) {
                this.brokerNameRouteData.put(brokerData.getBrokerName(), brokerData);
            }
        }
    }

    public String getMasterAddr(String brokerName) {
        return (String)this.brokerNameRouteData.get(brokerName).getBrokerAddrs().get(0L);
    }

    public String getMasterAddrPrefer(String brokerName) {
        HashMap brokerAddr = this.brokerNameRouteData.get(brokerName).getBrokerAddrs();
        String addr = (String)brokerAddr.get(0L);
        if (addr == null) {
            Optional optional = brokerAddr.keySet().stream().findFirst();
            return optional.map(brokerAddr::get).orElse(null);
        }
        return addr;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public TopicRouteData getTopicRouteData() {
        return this.topicRouteData;
    }

    public List<QueueData> getQueueDatas() {
        return this.topicRouteData.getQueueDatas();
    }

    public String getOrderTopicConf() {
        return this.topicRouteData.getOrderTopicConf();
    }
}

