/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.file;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.tieredstore.common.AppendResult;

public interface FlatFileInterface {
    public long getTopicId();

    public Lock getFileLock();

    public MessageQueue getMessageQueue();

    public boolean isFlatFileInit();

    public void initOffset(long var1);

    public boolean rollingFile(long var1);

    public AppendResult appendCommitLog(ByteBuffer var1);

    public AppendResult appendCommitLog(SelectMappedBufferResult var1);

    public AppendResult appendConsumeQueue(DispatchRequest var1);

    public List<DispatchRequest> getDispatchRequestList();

    public void release();

    public long getMinStoreTimestamp();

    public long getMaxStoreTimestamp();

    public long getFirstMessageOffset();

    public long getCommitLogMinOffset();

    public long getCommitLogMaxOffset();

    public long getCommitLogCommitOffset();

    public long getConsumeQueueMinOffset();

    public long getConsumeQueueMaxOffset();

    public long getConsumeQueueCommitOffset();

    public CompletableFuture<Boolean> commitAsync();

    public CompletableFuture<ByteBuffer> getMessageAsync(long var1);

    public CompletableFuture<ByteBuffer> getCommitLogAsync(long var1, int var3);

    public CompletableFuture<ByteBuffer> getConsumeQueueAsync(long var1);

    public CompletableFuture<ByteBuffer> getConsumeQueueAsync(long var1, int var3);

    public CompletableFuture<Long> getQueueOffsetByTimeAsync(long var1, BoundaryType var3);

    public void shutdown();

    public void destroyExpiredFile(long var1);

    public void destroy();
}

