/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service;

import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.ObjectCreator;
import org.apache.rocketmq.proxy.service.ClusterServiceManager;
import org.apache.rocketmq.proxy.service.LocalServiceManager;
import org.apache.rocketmq.proxy.service.ServiceManager;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.RemotingClient;

public class ServiceManagerFactory {
    public static ServiceManager createForLocalMode(BrokerController brokerController) {
        return ServiceManagerFactory.createForLocalMode(brokerController, null);
    }

    public static ServiceManager createForLocalMode(BrokerController brokerController, RPCHook rpcHook) {
        return new LocalServiceManager(brokerController, rpcHook);
    }

    public static ServiceManager createForClusterMode() {
        return ServiceManagerFactory.createForClusterMode(null, null);
    }

    public static ServiceManager createForClusterMode(RPCHook rpcHook) {
        return ServiceManagerFactory.createForClusterMode(rpcHook, null);
    }

    public static ServiceManager createForClusterMode(RPCHook rpcHook, ObjectCreator<RemotingClient> remotingClientCreator) {
        return new ClusterServiceManager(rpcHook, remotingClientCreator);
    }
}

