/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.monitor;

import java.util.Map;
import java.util.TreeMap;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.tools.monitor.DeleteMsgsEvent;
import org.apache.rocketmq.tools.monitor.FailedMsgs;
import org.apache.rocketmq.tools.monitor.MonitorListener;
import org.apache.rocketmq.tools.monitor.UndoneMsgs;

public class DefaultMonitorListener
implements MonitorListener {
    private static final String LOG_PREFIX = "[MONITOR] ";
    private static final String LOG_NOTIFY = "[MONITOR]  [NOTIFY] ";
    private final Logger logger = LoggerFactory.getLogger(DefaultMonitorListener.class);

    @Override
    public void beginRound() {
        this.logger.info("{}=========================================beginRound", (Object)LOG_PREFIX);
    }

    @Override
    public void reportUndoneMsgs(UndoneMsgs undoneMsgs) {
        this.logger.info("{}reportUndoneMsgs: {}", (Object)LOG_PREFIX, (Object)undoneMsgs);
    }

    @Override
    public void reportFailedMsgs(FailedMsgs failedMsgs) {
        this.logger.info("{}reportFailedMsgs: {}", (Object)LOG_PREFIX, (Object)failedMsgs);
    }

    @Override
    public void reportDeleteMsgsEvent(DeleteMsgsEvent deleteMsgsEvent) {
        this.logger.info("{}reportDeleteMsgsEvent: {}", (Object)LOG_PREFIX, (Object)deleteMsgsEvent);
    }

    @Override
    public void reportConsumerRunningInfo(TreeMap<String, ConsumerRunningInfo> criTable) {
        if (criTable == null || criTable.isEmpty()) {
            this.logger.warn("{}ConsumerRunningInfo is empty.", (Object)LOG_NOTIFY);
            return;
        }
        ConsumerRunningInfo firstValue = criTable.firstEntry().getValue();
        if (firstValue == null || firstValue.getProperties() == null) {
            this.logger.warn("{}ConsumerRunningInfo entry is empty.", (Object)LOG_NOTIFY);
            return;
        }
        String consumerGroup = firstValue.getProperties().getProperty("consumerGroup");
        boolean result = ConsumerRunningInfo.analyzeSubscription(criTable);
        if (!result) {
            this.logger.info("{}reportConsumerRunningInfo: ConsumerGroup: {}, Subscription different", (Object)LOG_NOTIFY, (Object)consumerGroup);
        }
        for (Map.Entry<String, ConsumerRunningInfo> next : criTable.entrySet()) {
            String result2 = ConsumerRunningInfo.analyzeProcessQueue((String)next.getKey(), (ConsumerRunningInfo)next.getValue());
            if (result2.isEmpty()) continue;
            this.logger.info("{}reportConsumerRunningInfo: ConsumerGroup: {}, ClientId: {}, {}", new Object[]{LOG_NOTIFY, consumerGroup, next.getKey(), result2});
        }
    }

    @Override
    public void endRound() {
        this.logger.info("{}=========================================endRound", (Object)LOG_PREFIX);
    }
}

