/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger;

import io.openmessaging.storage.dledger.utils.DLedgerUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class DLedgerConfig {
    public static final String MEMORY = "MEMORY";
    public static final String FILE = "FILE";
    public static final String MULTI_PATH_SPLITTER = System.getProperty("dLedger.multiPath.Splitter", ",");
    private String configFilePath;
    private String group = "default";
    private String selfId = "n0";
    private String peers = "n0-localhost:20911";
    private String storeBaseDir = File.separator + "tmp" + File.separator + "dledgerstore";
    private String readOnlyDataStoreDirs = null;
    private int peerPushThrottlePoint = 314572800;
    private int peerPushQuota = 0x1400000;
    private String storeType = "FILE";
    private String dataStorePath;
    private int maxPendingRequestsNum = 10000;
    private int maxWaitAckTimeMs = 2500;
    private int maxPushTimeOutMs = 1000;
    private boolean enableLeaderElector = true;
    private int heartBeatTimeIntervalMs = 2000;
    private int maxHeartBeatLeak = 3;
    private int minVoteIntervalMs = 300;
    private int maxVoteIntervalMs = 1000;
    private int fileReservedHours = 72;
    private String deleteWhen = "04";
    private float diskSpaceRatioToCheckExpired = Float.parseFloat(System.getProperty("dledger.disk.ratio.check", "0.70"));
    private float diskSpaceRatioToForceClean = Float.parseFloat(System.getProperty("dledger.disk.ratio.clean", "0.85"));
    private boolean enableDiskForceClean = true;
    private long flushFileInterval = 10L;
    private long checkPointInterval = 3000L;
    private int mappedFileSizeForEntryData = 0x40000000;
    private int mappedFileSizeForEntryIndex = 0xA000000;
    private boolean enablePushToFollower = true;
    private String preferredLeaderIds;
    private long maxLeadershipTransferWaitIndex = 1000L;
    private int minTakeLeadershipVoteIntervalMs = 30;
    private int maxTakeLeadershipVoteIntervalMs = 100;
    private boolean isEnableBatchPush = false;
    private int maxBatchPushSize = 4096;
    private long leadershipTransferWaitTimeout = 1000L;
    private int snapshotThreshold = 1000;
    private int maxSnapshotReservedNum = 3;
    private String selfAddress;
    private Map<String, String> peerAddressMap;
    private final AtomicBoolean inited = new AtomicBoolean(false);

    public String getDefaultPath() {
        return this.storeBaseDir + File.separator + "dledger-" + this.selfId;
    }

    public String getDataStorePath() {
        if (this.dataStorePath == null) {
            return this.getDefaultPath() + File.separator + "data";
        }
        return this.dataStorePath;
    }

    public void setDataStorePath(String dataStorePath) {
        this.dataStorePath = dataStorePath;
    }

    public String getSnapshotStoreBaseDir() {
        return this.getDefaultPath() + File.separator + "snapshot";
    }

    public String getIndexStorePath() {
        return this.getDefaultPath() + File.separator + "index";
    }

    public int getMappedFileSizeForEntryData() {
        return this.mappedFileSizeForEntryData;
    }

    public void setMappedFileSizeForEntryData(int mappedFileSizeForEntryData) {
        this.mappedFileSizeForEntryData = mappedFileSizeForEntryData;
    }

    public int getMappedFileSizeForEntryIndex() {
        return this.mappedFileSizeForEntryIndex;
    }

    public void setMappedFileSizeForEntryIndex(int mappedFileSizeForEntryIndex) {
        this.mappedFileSizeForEntryIndex = mappedFileSizeForEntryIndex;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getSelfId() {
        return this.selfId;
    }

    public void setSelfId(String selfId) {
        this.selfId = selfId;
    }

    public String getPeers() {
        return this.peers;
    }

    public void setPeers(String peers) {
        this.peers = peers;
    }

    public String getStoreBaseDir() {
        return this.storeBaseDir;
    }

    public void setStoreBaseDir(String storeBaseDir) {
        this.storeBaseDir = storeBaseDir;
    }

    public String getStoreType() {
        return this.storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public boolean isEnableLeaderElector() {
        return this.enableLeaderElector;
    }

    public void setEnableLeaderElector(boolean enableLeaderElector) {
        this.enableLeaderElector = enableLeaderElector;
    }

    public DLedgerConfig group(String group) {
        this.group = group;
        return this;
    }

    public DLedgerConfig selfId(String selfId) {
        this.selfId = selfId;
        return this;
    }

    public DLedgerConfig peers(String peers) {
        this.peers = peers;
        return this;
    }

    public DLedgerConfig storeBaseDir(String dir) {
        this.storeBaseDir = dir;
        return this;
    }

    public boolean isEnablePushToFollower() {
        return this.enablePushToFollower;
    }

    public void setEnablePushToFollower(boolean enablePushToFollower) {
        this.enablePushToFollower = enablePushToFollower;
    }

    public int getMaxPendingRequestsNum() {
        return this.maxPendingRequestsNum;
    }

    public void setMaxPendingRequestsNum(int maxPendingRequestsNum) {
        this.maxPendingRequestsNum = maxPendingRequestsNum;
    }

    public int getMaxWaitAckTimeMs() {
        return this.maxWaitAckTimeMs;
    }

    public void setMaxWaitAckTimeMs(int maxWaitAckTimeMs) {
        this.maxWaitAckTimeMs = maxWaitAckTimeMs;
    }

    public int getMaxPushTimeOutMs() {
        return this.maxPushTimeOutMs;
    }

    public void setMaxPushTimeOutMs(int maxPushTimeOutMs) {
        this.maxPushTimeOutMs = maxPushTimeOutMs;
    }

    public int getHeartBeatTimeIntervalMs() {
        return this.heartBeatTimeIntervalMs;
    }

    public void setHeartBeatTimeIntervalMs(int heartBeatTimeIntervalMs) {
        this.heartBeatTimeIntervalMs = heartBeatTimeIntervalMs;
    }

    public int getMinVoteIntervalMs() {
        return this.minVoteIntervalMs;
    }

    public void setMinVoteIntervalMs(int minVoteIntervalMs) {
        this.minVoteIntervalMs = minVoteIntervalMs;
    }

    public int getMaxVoteIntervalMs() {
        return this.maxVoteIntervalMs;
    }

    public void setMaxVoteIntervalMs(int maxVoteIntervalMs) {
        this.maxVoteIntervalMs = maxVoteIntervalMs;
    }

    public String getDeleteWhen() {
        return this.deleteWhen;
    }

    public void setDeleteWhen(String deleteWhen) {
        this.deleteWhen = deleteWhen;
    }

    public float getDiskSpaceRatioToCheckExpired() {
        return this.diskSpaceRatioToCheckExpired;
    }

    public void setDiskSpaceRatioToCheckExpired(float diskSpaceRatioToCheckExpired) {
        this.diskSpaceRatioToCheckExpired = diskSpaceRatioToCheckExpired;
    }

    public float getDiskSpaceRatioToForceClean() {
        if (this.diskSpaceRatioToForceClean < 0.5f) {
            return 0.5f;
        }
        return this.diskSpaceRatioToForceClean;
    }

    public void setDiskSpaceRatioToForceClean(float diskSpaceRatioToForceClean) {
        this.diskSpaceRatioToForceClean = diskSpaceRatioToForceClean;
    }

    public float getDiskFullRatio() {
        float ratio = this.diskSpaceRatioToForceClean + 0.05f;
        if (ratio > 0.95f) {
            return 0.95f;
        }
        return ratio;
    }

    public int getFileReservedHours() {
        return this.fileReservedHours;
    }

    public void setFileReservedHours(int fileReservedHours) {
        this.fileReservedHours = fileReservedHours;
    }

    public long getFlushFileInterval() {
        return this.flushFileInterval;
    }

    public void setFlushFileInterval(long flushFileInterval) {
        this.flushFileInterval = flushFileInterval;
    }

    public boolean isEnableDiskForceClean() {
        return this.enableDiskForceClean;
    }

    public void setEnableDiskForceClean(boolean enableDiskForceClean) {
        this.enableDiskForceClean = enableDiskForceClean;
    }

    public int getMaxHeartBeatLeak() {
        return this.maxHeartBeatLeak;
    }

    public void setMaxHeartBeatLeak(int maxHeartBeatLeak) {
        this.maxHeartBeatLeak = maxHeartBeatLeak;
    }

    public int getPeerPushThrottlePoint() {
        return this.peerPushThrottlePoint;
    }

    public void setPeerPushThrottlePoint(int peerPushThrottlePoint) {
        this.peerPushThrottlePoint = peerPushThrottlePoint;
    }

    public int getPeerPushQuota() {
        return this.peerPushQuota;
    }

    public void setPeerPushQuota(int peerPushQuota) {
        this.peerPushQuota = peerPushQuota;
    }

    public long getCheckPointInterval() {
        return this.checkPointInterval;
    }

    public void setCheckPointInterval(long checkPointInterval) {
        this.checkPointInterval = checkPointInterval;
    }

    @Deprecated
    public String getPreferredLeaderId() {
        return this.preferredLeaderIds;
    }

    @Deprecated
    public void setPreferredLeaderId(String preferredLeaderId) {
        this.preferredLeaderIds = preferredLeaderId;
    }

    public String getPreferredLeaderIds() {
        return this.preferredLeaderIds;
    }

    public void setPreferredLeaderIds(String preferredLeaderIds) {
        this.preferredLeaderIds = preferredLeaderIds;
    }

    public long getMaxLeadershipTransferWaitIndex() {
        return this.maxLeadershipTransferWaitIndex;
    }

    public void setMaxLeadershipTransferWaitIndex(long maxLeadershipTransferWaitIndex) {
        this.maxLeadershipTransferWaitIndex = maxLeadershipTransferWaitIndex;
    }

    public int getMinTakeLeadershipVoteIntervalMs() {
        return this.minTakeLeadershipVoteIntervalMs;
    }

    public void setMinTakeLeadershipVoteIntervalMs(int minTakeLeadershipVoteIntervalMs) {
        this.minTakeLeadershipVoteIntervalMs = minTakeLeadershipVoteIntervalMs;
    }

    public int getMaxTakeLeadershipVoteIntervalMs() {
        return this.maxTakeLeadershipVoteIntervalMs;
    }

    public void setMaxTakeLeadershipVoteIntervalMs(int maxTakeLeadershipVoteIntervalMs) {
        this.maxTakeLeadershipVoteIntervalMs = maxTakeLeadershipVoteIntervalMs;
    }

    public boolean isEnableBatchPush() {
        return this.isEnableBatchPush;
    }

    public void setEnableBatchPush(boolean enableBatchPush) {
        this.isEnableBatchPush = enableBatchPush;
    }

    public int getMaxBatchPushSize() {
        return this.maxBatchPushSize;
    }

    public void setMaxBatchPushSize(int maxBatchPushSize) {
        this.maxBatchPushSize = maxBatchPushSize;
    }

    public long getLeadershipTransferWaitTimeout() {
        return this.leadershipTransferWaitTimeout;
    }

    public void setLeadershipTransferWaitTimeout(long leadershipTransferWaitTimeout) {
        this.leadershipTransferWaitTimeout = leadershipTransferWaitTimeout;
    }

    public String getReadOnlyDataStoreDirs() {
        return this.readOnlyDataStoreDirs;
    }

    public void setReadOnlyDataStoreDirs(String readOnlyDataStoreDirs) {
        this.readOnlyDataStoreDirs = readOnlyDataStoreDirs;
    }

    public void init() {
        if (this.inited.compareAndSet(false, true)) {
            this.initSelfAddress();
            this.initPeerAddressMap();
        }
    }

    private void initSelfAddress() {
        for (String peerInfo : this.peers.split(";")) {
            String peerSelfId = peerInfo.split("-")[0];
            String peerAddress = peerInfo.substring(peerSelfId.length() + 1);
            if (!this.selfId.equals(peerSelfId)) continue;
            this.selfAddress = peerAddress;
            return;
        }
        throw new IllegalArgumentException("[DLedgerConfig] fail to init self address, config: " + this);
    }

    private void initPeerAddressMap() {
        HashMap<String, String> peerMap = new HashMap<String, String>();
        for (String peerInfo : this.peers.split(";")) {
            String peerSelfId = peerInfo.split("-")[0];
            String peerAddress = peerInfo.substring(peerSelfId.length() + 1);
            peerMap.put(DLedgerUtils.generateDLedgerId(this.group, peerSelfId), peerAddress);
        }
        this.peerAddressMap = peerMap;
    }

    public String getSelfAddress() {
        return this.selfAddress;
    }

    public Map<String, String> getPeerAddressMap() {
        return this.peerAddressMap;
    }

    public int getSnapshotThreshold() {
        return this.snapshotThreshold;
    }

    public void setSnapshotThreshold(int snapshotThreshold) {
        this.snapshotThreshold = snapshotThreshold;
    }

    public int getMaxSnapshotReservedNum() {
        return this.maxSnapshotReservedNum;
    }

    public void setMaxSnapshotReservedNum(int maxSnapshotReservedNum) {
        this.maxSnapshotReservedNum = maxSnapshotReservedNum;
    }
}

