/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.rocketmq.client.java.misc;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadFactoryImpl implements ThreadFactory {
    public static final String THREAD_PREFIX = "Rocketmq";

    private static final AtomicLong THREAD_INDEX = new AtomicLong(0);
    private final String customName;
    private final boolean daemon;

    public ThreadFactoryImpl(final String customName) {
        this(customName, false);
    }

    public ThreadFactoryImpl(final String customName, final long clientIndex) {
        this(customName + "-" + clientIndex, false);
    }

    public ThreadFactoryImpl(final String customName, boolean daemon) {
        this.customName = customName;
        this.daemon = daemon;
    }

    @SuppressWarnings("NullableProblems")
    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r, THREAD_PREFIX + customName + "-" + THREAD_INDEX.incrementAndGet());
        thread.setDaemon(daemon);
        return thread;
    }
}