/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.rpc;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.rocketmq.shaded.io.grpc.EquivalentAddressGroup;
import org.apache.rocketmq.shaded.io.grpc.NameResolver;
import org.apache.rocketmq.shaded.io.grpc.NameResolverProvider;

public class IpNameResolverFactory
extends NameResolverProvider {
    private final List<EquivalentAddressGroup> addresses;
    private final String serviceAuthority = "IPAuthority";
    private NameResolver.Listener2 listener2;

    public IpNameResolverFactory(List<InetSocketAddress> socketAddresses) {
        this.addresses = this.convertAddresses(socketAddresses);
    }

    private List<EquivalentAddressGroup> convertAddresses(List<InetSocketAddress> socketAddresses) {
        ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
        for (InetSocketAddress socketAddress : socketAddresses) {
            addresses.add(new EquivalentAddressGroup(socketAddress));
        }
        Collections.shuffle(addresses);
        return addresses;
    }

    @Override
    public NameResolver newNameResolver(URI notUsedUri, NameResolver.Args args) {
        return new NameResolver(){

            @Override
            public String getServiceAuthority() {
                return "IPAuthority";
            }

            @Override
            public void start(NameResolver.Listener2 listener2) {
                IpNameResolverFactory.this.listener2 = listener2;
                listener2.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses(IpNameResolverFactory.this.addresses).build());
            }

            @Override
            public void shutdown() {
            }
        };
    }

    @Override
    public String getDefaultScheme() {
        return "IP";
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 0;
    }
}

