/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.meta;

import com.alipay.sofa.jraft.error.RemotingException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.facade.MetaPersistManager;
import org.apache.rocketmq.mqtt.common.facade.RetainedPersistManager;
import org.apache.rocketmq.mqtt.common.model.Message;
import org.apache.rocketmq.mqtt.common.model.Subscription;
import org.apache.rocketmq.mqtt.ds.meta.RetainedMsgClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetainedPersistManagerImpl
implements RetainedPersistManager {
    private static Logger logger = LoggerFactory.getLogger(RetainedPersistManagerImpl.class);
    @Resource
    private MetaPersistManager metaPersistManager;
    @Resource
    private RetainedMsgClient retainedMsgClient;

    public void init() {
    }

    public CompletableFuture<Boolean> storeRetainedMessage(String topic, Message message) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!this.metaPersistManager.getAllFirstTopics().contains(message.getFirstTopic())) {
            logger.info("Put retained message of topic {} into meta failed. Because first topic {} does not exist...", (Object)topic, (Object)message.getFirstTopic());
            result.complete(false);
            return result;
        }
        logger.debug("Start store retain msg...");
        try {
            this.retainedMsgClient.setRetainedMsg(topic, message, result);
        }
        catch (RemotingException | InterruptedException e) {
            logger.error("", e);
            result.completeExceptionally(e);
        }
        return result;
    }

    public CompletableFuture<Message> getRetainedMessage(String preciseTopic) {
        CompletableFuture<Message> future = new CompletableFuture<Message>();
        logger.debug("topic:" + preciseTopic);
        try {
            this.retainedMsgClient.GetRetainedMsg(preciseTopic, future);
        }
        catch (RemotingException | InterruptedException e) {
            logger.error("", e);
            future.completeExceptionally(e);
        }
        return future;
    }

    public CompletableFuture<ArrayList<Message>> getMsgsFromTrie(Subscription subscription) {
        String firstTopic = subscription.toFirstTopic();
        String originTopicFilter = subscription.getTopicFilter();
        logger.debug("firstTopic={} originTopicFilter={}", (Object)firstTopic, (Object)originTopicFilter);
        CompletableFuture<ArrayList<Message>> future = new CompletableFuture<ArrayList<Message>>();
        try {
            this.retainedMsgClient.GetRetainedMsgsFromTrie(firstTopic, originTopicFilter, future);
        }
        catch (RemotingException | InterruptedException e) {
            logger.error("", e);
            future.completeExceptionally(e);
        }
        return future;
    }
}

