/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.meta;

import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.model.consistency.ReadRequest;
import org.apache.rocketmq.mqtt.common.model.consistency.Response;
import org.apache.rocketmq.mqtt.common.model.consistency.WriteRequest;
import org.apache.rocketmq.mqtt.ds.meta.MetaRpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WillMsgClient {
    private static Logger logger = LoggerFactory.getLogger(WillMsgClient.class);
    @Resource
    private MetaRpcClient metaRpcClient;

    public void put(String key, String value, CompletableFuture<Boolean> future) throws Exception {
        String groupId = this.whichGroup();
        WriteRequest request = WriteRequest.newBuilder().setGroup(groupId).setKey(key).setData(ByteString.copyFrom((byte[])value.getBytes())).setOperation("put").setCategory("willMsg").build();
        this.metaRpcClient.getCliClientService().getRpcClient().invokeAsync(this.metaRpcClient.getLeader(groupId).getEndpoint(), (Object)request, (result, err) -> {
            if (err == null) {
                Response rsp = (Response)result;
                if (!rsp.getSuccess()) {
                    logger.info("put kv failed. k:{} , v:{}, {}", new Object[]{key, value, rsp.getErrMsg()});
                    future.complete(false);
                    return;
                }
                logger.debug("put kv success. k:{} , v:{}", (Object)key, (Object)value);
                future.complete(true);
            } else {
                logger.error("put kv failed. k:{} , v:{}", new Object[]{key, value, err});
                future.completeExceptionally(err);
            }
        }, 5000L);
    }

    public void delete(String key, CompletableFuture<Boolean> future) throws Exception {
        String groupId = this.whichGroup();
        WriteRequest request = WriteRequest.newBuilder().setGroup(groupId).setKey(key).setOperation("delete").setCategory("willMsg").build();
        this.metaRpcClient.getCliClientService().getRpcClient().invokeAsync(this.metaRpcClient.getLeader(groupId).getEndpoint(), (Object)request, (result, err) -> {
            if (err == null) {
                Response rsp = (Response)result;
                if (!rsp.getSuccess()) {
                    logger.info("delete kv failed. k:{} ,{}", (Object)key, (Object)rsp.getErrMsg());
                    future.complete(false);
                    return;
                }
                logger.debug("delete kv success. k:{}", (Object)key);
                future.complete(true);
            } else {
                logger.error("delete kv failed. k:{}", (Object)key, (Object)err);
                future.completeExceptionally(err);
            }
        }, 5000L);
    }

    public void get(String key, CompletableFuture<byte[]> future) throws Exception {
        String groupId = this.whichGroup();
        ReadRequest request = ReadRequest.newBuilder().setGroup(groupId).setKey(key).setOperation("get").setType("readIndexType").setCategory("willMsg").build();
        this.metaRpcClient.getCliClientService().getRpcClient().invokeAsync(this.metaRpcClient.getLeader(groupId).getEndpoint(), (Object)request, (result, err) -> {
            if (err == null) {
                Response rsp = (Response)result;
                if (!rsp.getSuccess()) {
                    logger.info("get value failed. k:{}, {}", (Object)key, (Object)rsp.getErrMsg());
                    future.complete(null);
                    return;
                }
                future.complete(rsp.getData().toByteArray());
            } else {
                logger.error("get value failed. k:{}", (Object)key, (Object)err);
                future.completeExceptionally(err);
            }
        }, 5000L);
    }

    public void compareAndPut(String key, String expectValue, String updateValue, CompletableFuture<Boolean> future) throws Exception {
        String groupId = this.whichGroup();
        WriteRequest request = WriteRequest.newBuilder().setGroup(groupId).setKey(key).setData(ByteString.copyFrom((byte[])updateValue.getBytes())).setOperation("compareAndPut").putExtData("expectValue", expectValue).setCategory("willMsg").build();
        this.metaRpcClient.getCliClientService().getRpcClient().invokeAsync(this.metaRpcClient.getLeader(groupId).getEndpoint(), (Object)request, (result, err) -> {
            if (err == null) {
                Response rsp = (Response)result;
                if (!rsp.getSuccess()) {
                    logger.info("compareAndPut kv failed. k:{} , v:{}, {}", new Object[]{key, updateValue, rsp.getErrMsg()});
                    future.complete(false);
                    return;
                }
                logger.debug("compareAndPut kv success. k:{} , v:{}", (Object)key, (Object)updateValue);
                future.complete(true);
            } else {
                logger.error("compareAndPut kv failed. k:{} , v:{}", new Object[]{key, updateValue, err});
                future.completeExceptionally(err);
            }
        }, 5000L);
    }

    public void scan(String startKey, String endKey, CompletableFuture<Map<String, String>> future) throws Exception {
        String groupId = this.whichGroup();
        ReadRequest request = ReadRequest.newBuilder().setGroup(groupId).setOperation("scan").putExtData("startKey", startKey).putExtData("endKey", endKey).setType("readIndexType").setCategory("willMsg").build();
        this.metaRpcClient.getCliClientService().getRpcClient().invokeAsync(this.metaRpcClient.getLeader(groupId).getEndpoint(), (Object)request, (result, err) -> {
            if (err == null) {
                Response rsp = (Response)result;
                if (!rsp.getSuccess()) {
                    logger.info("scan failed. startKey:{}, endKey:{}, {}", new Object[]{startKey, endKey, rsp.getErrMsg()});
                    future.complete(null);
                    return;
                }
                Map res = rsp.getDataMapMap();
                future.complete(res);
            } else {
                logger.error("scan failed. startKey:{}, endKey:{}", new Object[]{startKey, endKey, err});
                future.completeExceptionally(err);
            }
        }, 5000L);
    }

    private String whichGroup() {
        return this.metaRpcClient.getRaftGroups()[1];
    }
}

