/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.notify;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.mqtt.common.facade.MetaPersistManager;
import org.apache.rocketmq.mqtt.common.model.MessageEvent;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;
import org.apache.rocketmq.mqtt.ds.config.ServiceConf;
import org.apache.rocketmq.mqtt.ds.meta.FirstTopicManager;
import org.apache.rocketmq.mqtt.ds.meta.TopicNotExistException;
import org.apache.rocketmq.mqtt.ds.mq.MqFactory;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingClient;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NotifyManager {
    private static Logger logger = LoggerFactory.getLogger(NotifyManager.class);
    private DefaultMQPushConsumer defaultMQPushConsumer;
    private String dispatcherConsumerGroup = "CID_RMQ_SYS_mqtt_event";
    private ScheduledThreadPoolExecutor scheduler;
    private Set<String> topics = new HashSet<String>();
    private Map<String, AtomicInteger> nodeFail = new ConcurrentHashMap<String, AtomicInteger>();
    private static final int NODE_FAIL_MAX_NUM = 3;
    private NettyRemotingClient remotingClient;
    private DefaultMQProducer defaultMQProducer;
    @Resource
    private ServiceConf serviceConf;
    @Resource
    private MetaPersistManager metaPersistManager;
    @Resource
    private FirstTopicManager firstTopicManager;

    @PostConstruct
    public void init() throws MQClientException {
        this.defaultMQPushConsumer = MqFactory.buildDefaultMQPushConsumer(this.dispatcherConsumerGroup, this.serviceConf.getProperties(), (MessageListener)new Dispatcher());
        this.defaultMQPushConsumer.setPullInterval(1L);
        this.defaultMQPushConsumer.setConsumeMessageBatchMaxSize(64);
        this.defaultMQPushConsumer.setPullBatchSize(32);
        this.defaultMQPushConsumer.setConsumeThreadMin(32);
        this.defaultMQPushConsumer.setConsumeThreadMax(64);
        this.defaultMQProducer = MqFactory.buildDefaultMQProducer("CID_RMQ_SYS_NotifyRetrySend", this.serviceConf.getProperties());
        try {
            this.defaultMQPushConsumer.start();
            this.defaultMQProducer.start();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        this.scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("Refresh_Notify_Topic_"));
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.refresh();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }, 0L, 5L, TimeUnit.SECONDS);
        NettyClientConfig config = new NettyClientConfig();
        this.remotingClient = new NettyRemotingClient(config);
        this.remotingClient.start();
    }

    private void refresh() throws MQClientException {
        Set tmp = this.metaPersistManager.getAllFirstTopics();
        if (tmp == null || tmp.isEmpty()) {
            return;
        }
        HashSet<String> thisTopicList = new HashSet<String>();
        for (String topic : tmp) {
            try {
                if (topic.equals(this.serviceConf.getClientRetryTopic())) continue;
                this.firstTopicManager.checkFirstTopicIfCreated(topic);
                thisTopicList.add(topic);
                if (this.topics.contains(topic)) continue;
                this.subscribe(topic);
                this.topics.add(topic);
            }
            catch (TopicNotExistException e) {
                logger.error("", (Throwable)e);
            }
        }
        Iterator<String> iterator = this.topics.iterator();
        while (iterator.hasNext()) {
            String topic;
            topic = iterator.next();
            if (thisTopicList.contains(topic)) continue;
            iterator.remove();
            this.unsubscribe(topic);
        }
    }

    private void subscribe(String topic) throws MQClientException {
        this.defaultMQPushConsumer.subscribe(topic, "*");
        logger.warn("subscribe:{}", (Object)topic);
    }

    private void unsubscribe(String topic) {
        try {
            logger.warn("unsubscribe:{}", (Object)topic);
            this.defaultMQPushConsumer.unsubscribe(topic);
            this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getRebalanceImpl().getTopicSubscribeInfoTable().remove(topic);
            this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getmQClientFactory().getDefaultMQProducer().getDefaultMQProducerImpl().getTopicPublishInfoTable().remove(topic);
        }
        catch (Exception e) {
            logger.error("{}", (Object)topic, (Object)e);
        }
    }

    private void setPubTopic(MessageEvent messageEvent, MessageExt message) {
        if (StringUtils.isNotBlank((CharSequence)message.getUserProperty("originMqttTopic"))) {
            messageEvent.setPubTopic(message.getUserProperty("originMqttTopic"));
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)message.getUserProperty("INNER_MULTI_DISPATCH"))) {
            String[] lmqSet;
            String s = message.getUserProperty("INNER_MULTI_DISPATCH");
            for (String lmq : lmqSet = s.split(",")) {
                if (TopicUtils.isWildCard((String)lmq) || !lmq.contains("%LMQ%")) continue;
                String originQueue = lmq.replace("%LMQ%", "");
                messageEvent.setPubTopic(StringUtils.replace((String)originQueue, (String)"%", (String)"/"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMessage(Set<MessageEvent> messageEvents) throws MQBrokerException, RemotingException, InterruptedException, MQClientException {
        Set connectorNodes = this.metaPersistManager.getConnectNodeSet();
        if (connectorNodes == null || connectorNodes.isEmpty()) {
            throw new RemotingException("No Connect Nodes");
        }
        for (String node : connectorNodes) {
            boolean result = false;
            try {
                AtomicInteger old;
                AtomicInteger nodeFailCount = this.nodeFail.get(node);
                if (nodeFailCount == null && (old = this.nodeFail.putIfAbsent(node, nodeFailCount = new AtomicInteger())) != null) {
                    nodeFailCount = old;
                }
                if (nodeFailCount.get() > 3) {
                    this.sendEventRetryMsg(messageEvents, 1, node, 0);
                    continue;
                }
                result = this.doNotify(node, messageEvents);
                if (result) {
                    nodeFailCount.set(0);
                    continue;
                }
                nodeFailCount.incrementAndGet();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                result = false;
            }
            finally {
                if (result) continue;
                this.sendEventRetryMsg(messageEvents, 1, node, 0);
            }
        }
    }

    protected boolean doNotify(String node, Set<MessageEvent> messageEvents) {
        Set connectorNodes = this.metaPersistManager.getConnectNodeSet();
        if (connectorNodes == null || connectorNodes.isEmpty()) {
            return false;
        }
        if (!connectorNodes.contains(node)) {
            return true;
        }
        try {
            RemotingCommand eventCommand = this.createMsgEventCommand(messageEvents);
            RemotingCommand response = this.remotingClient.invokeSync(node + ":" + this.serviceConf.getCsRpcPort(), eventCommand, 1000L);
            return response.getCode() == 1;
        }
        catch (Exception e) {
            logger.error("fail notify {}", (Object)node, (Object)e);
            return false;
        }
    }

    private RemotingCommand createMsgEventCommand(Set<MessageEvent> messageEvents) {
        RemotingCommand remotingCommand = RemotingCommand.createRequestCommand((int)201, null);
        remotingCommand.setBody(JSON.toJSONBytes(messageEvents, (SerializerFeature[])new SerializerFeature[0]));
        return remotingCommand;
    }

    protected void sendEventRetryMsg(Set<MessageEvent> messageEvents, int delayLevel, String node, int retryTime) throws InterruptedException, RemotingException, MQClientException, MQBrokerException {
        if (retryTime >= this.serviceConf.getEventNotifyRetryMaxTime()) {
            return;
        }
        Message message = new Message();
        message.setTopic(this.serviceConf.getEventNotifyRetryTopic());
        message.setBody(JSON.toJSONBytes(messageEvents, (SerializerFeature[])new SerializerFeature[0]));
        message.setDelayTimeLevel(delayLevel);
        message.putUserProperty("retryNode", node);
        message.putUserProperty("retryTime", String.valueOf(retryTime + 1));
        this.defaultMQProducer.send(message);
    }

    class Dispatcher
    implements MessageListenerConcurrently {
        Dispatcher() {
        }

        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
            try {
                HashSet<MessageEvent> messageEvents = new HashSet<MessageEvent>();
                for (MessageExt message : msgs) {
                    MessageEvent messageEvent = new MessageEvent();
                    messageEvent.setBrokerName(context.getMessageQueue().getBrokerName());
                    NotifyManager.this.setPubTopic(messageEvent, message);
                    String namespace = message.getUserProperty("namespace");
                    messageEvent.setNamespace(namespace);
                    messageEvents.add(messageEvent);
                }
                NotifyManager.this.notifyMessage(messageEvents);
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                return ConsumeConcurrentlyStatus.RECONSUME_LATER;
            }
        }
    }
}

